"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = void 0;
exports.SectionLink = SectionLink;
exports.SectionLinks = SectionLinks;
exports.SectionSpacer = SectionSpacer;
exports.SectionSubtitle = SectionSubtitle;
exports.SectionTitle = SectionTitle;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SectionTitle({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h5", null, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs'
  }));
}
function SectionSubtitle({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    color: 'subdued',
    grow: false
  }, /*#__PURE__*/_react.default.createElement("small", null, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }));
}
function SectionLinks({
  children,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, (0, _extends2.default)({}, props, {
    flush: true,
    bordered: false
  }), children);
}
function SectionSpacer() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  });
}
const Section = _styledComponents.default.div`
  margin-bottom: 16px;
  &:last-of-type {
    margin-bottom: 0;
  }
`;
exports.Section = Section;
function SectionLink(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({
    style: {
      padding: 0
    },
    size: 'xs'
  }, props));
}