/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.observability_bundle_jsonpfunction=window.observability_bundle_jsonpfunction||[]).push([[12],{84:function(e,t,s){"use strict";s.r(t),s.d(t,"coPilotPrompts",(function(){return m}));var n=s(0),o=s(22);const i={content:"You are perf-gpt, a helpful assistant for performance analysis and optimisation\n    of software. Answer as concisely as possible.",role:"system"},a={content:"You are apm-gpt, a helpful assistant for performance analysis, optimisation and\n    root cause analysis of software. Answer as concisely as possible.",role:"system"},r={content:"You are logs-gpt, a helpful assistant for logs-based observability. Answer as\n    concisely as possible.",role:"system"},c={content:"You are infra-gpt, a helpful assistant for metrics-based infrastructure observability. Answer as\n    concisely as possible.",role:"system"};function l({params:e,messages:t}){return{params:e,messages:t}}const u=n.type({fields:n.array(n.type({field:n.string,value:n.array(n.any)}))}),h=n.array(n.type({field:n.string,value:n.union([n.string,n.number]),docCount:n.number,pValue:n.union([n.number,n.null])})),m={[o.a.ProfilingOptimizeFunction]:l({params:n.type({library:n.string,functionName:n.string}),messages:({library:e,functionName:t})=>[i,{content:`I am a software engineer. I am trying to understand what a function in a particular\n          software library does.\n          \n          The library is: ${e}\n          The function is: ${t}\n          \n          Your have two tasks. Your first task is to desribe what the library is and what its use cases are, and to\n          describe what the function does. The output format should look as follows:\n          \n          Library description: Provide a concise description of the library\n          Library use-cases: Provide a concise description of what the library is typically used for.\n          Function description: Provide a concise, technical, description of what the function does.\n          \n          Assume the function ${t} from the library ${e} is consuming significant CPU resources.\n          Your second task is to suggest ways to optimize or improve the system that involve the ${t} function from the\n          ${e} library. Types of improvements that would be useful to me are improvements that result in:\n          \n          - Higher performance so that the system runs faster or uses less CPU\n          - Better memory efficient so that the system uses less RAM\n          - Better storage efficient so that the system stores less data on disk.\n          - Better network I/O efficiency so that less data is sent over the network\n          - Better disk I/O efficiency so that less data is read and written from disk\n          \n          Make up to five suggestions. Your suggestions must meet all of the following criteria:\n          1. Your suggestions should detailed, technical and include concrete examples.\n          2. Your suggestions should be specific to improving performance of a system in which the ${t} function from\n          the ${e} library is consuming significant CPU.\n          3. If you suggest replacing the function or library with a more efficient replacement you must suggest at least\n          one concrete replacement.\n          \n          If you know of fewer than five ways to improve the performance of a system in which the ${t} function from the\n          ${e} library is consuming significant CPU, then provide fewer than five suggestions. If you do not know of any\n          way in which to improve the performance then say "I do not know how to improve the performance of systems where\n          this function is consuming a significant amount of CPU".\n          \n          Do not suggest using a CPU profiler. I have already profiled my code. The profiler I used is Elastic Universal Profiler.\n          If there is specific information I should look for in the profiler output then tell me what information to look for\n          in the output of Elastic Universal Profiler.\n          \n          You must not include URLs, web addresses or websites of any kind in your output.\n          \n          If you have suggestions, the output format should look as follows:\n          \n          Here are some suggestions as to how you might optimize your system if ${t} in ${e} is consuming\n          significant CPU resources:\n          1. Insert first suggestion\n          2. Insert second suggestion`,role:"user"}]}),[o.a.ApmExplainError]:l({params:n.intersection([n.type({serviceName:n.string,languageName:n.string,runtimeName:n.string,runtimeVersion:n.string,transactionName:n.string,logStacktrace:n.string,exceptionStacktrace:n.string}),n.partial({spanName:n.string})]),messages:({serviceName:e,languageName:t,runtimeName:s,runtimeVersion:n,transactionName:o,logStacktrace:i,exceptionStacktrace:r})=>[a,{content:`I'm an SRE. I am looking at an exception and trying to understand what it means.\n\n          Your task is to describe what the error means and what it could be caused by.\n\n          The error occurred on a service called ${e}, which is a ${s} service written in ${t}. The\n          runtime version is ${n}.\n\n          The request it occurred for is called ${o}.\n\n          ${i?`The log stacktrace:\n          ${i}`:""}\n\n          ${r?`The exception stacktrace:\n          ${r}`:""}\n          `,role:"user"}]}),[o.a.LogsExplainMessage]:l({params:n.type({logEntry:u}),messages:({logEntry:e})=>[r,{content:`I'm looking at a log entry. Can you explain me what the log message means? Where it could be coming from, whether it is expected and whether it is an issue. Here's the context, serialized: ${JSON.stringify(e)} `,role:"user"}]}),[o.a.LogsFindSimilar]:l({params:n.type({logEntry:u}),messages:({logEntry:e})=>{var t;const s=null===(t=e.fields.find((e=>"message"===e.field)))||void 0===t?void 0:t.value[0];return[r,{content:`I'm looking at a log entry. Can you construct a Kibana KQL query that I can enter in the search bar that gives me similar log entries, based on the \`message\` field: ${s}`,role:"user"}]}}),[o.a.InfraExplainProcess]:l({params:n.type({command:n.string}),messages:({command:e})=>[c,{content:`I am a software engineer. I am trying to understand what a process running on my\n          machine does.\n\n          Your task is to first describe what the process is and what its general use cases are. If I also provide you\n          with the arguments to the process you should then explain its arguments and how they influence the behaviour\n          of the process. If I do not provide any arguments then explain the behaviour of the process when no arguments are\n          provided.\n\n          If you do not recognise the process say "No information available for this process". If I provide an argument\n          to the process that you do not recognise then say "No information available for this argument" when explaining\n          that argument.\n\n          Here is an example with arguments.\n          Process: metricbeat -c /etc/metricbeat.yml -d autodiscover,kafka -e -system.hostfs=/hostfs\n          Explanation: Metricbeat is part of the Elastic Stack. It is a lightweight shipper that you can install on your\n          servers to periodically collect metrics from the operating system and from services running on the server.\n          Use cases for Metricbeat generally revolve around infrastructure monitoring. You would typically install\n          Metricbeat on your servers to collect metrics from your systems and services. These metrics are then\n          used for performance monitoring, anomaly detection, system status checks, etc.\n\n          Here is a breakdown of the arguments used:\n\n          * -c /etc/metricbeat.yml: The -c option is used to specify the configuration file for Metricbeat. In\n          this case, /etc/metricbeat.yml is the configuration file. This file contains configurations for what\n          metrics to collect and where to send them (e.g., to Elasticsearch or Logstash).\n\n          * -d autodiscover,kafka: The -d option is used to enable debug output for selected components. In\n          this case, debug output is enabled for autodiscover and kafka components. The autodiscover feature\n          allows Metricbeat to automatically discover services as they get started and stopped in your environment,\n          and kafka is presumably a monitored service from which Metricbeat collects metrics.\n\n          * -e: The -e option is used to log to stderr and disable syslog/file output. This is useful for debugging.\n\n          * -system.hostfs=/hostfs: The -system.hostfs option is used to set the mount point of the host’s\n          filesystem for use in monitoring a host from within a container. In this case, /hostfs is the mount\n          point. When running Metricbeat inside a container, filesystem metrics would be for the container by\n          default, but with this option, Metricbeat can get metrics for the host system.\n\n          Here is an example without arguments.\n          Process: metricbeat\n          Explanation: Metricbeat is part of the Elastic Stack. It is a lightweight shipper that you can install on your\n          servers to periodically collect metrics from the operating system and from services running on the server.\n          Use cases for Metricbeat generally revolve around infrastructure monitoring. You would typically install\n          Metricbeat on your servers to collect metrics from your systems and services. These metrics are then\n          used for performance monitoring, anomaly detection, system status checks, etc.\n\n          Running it without any arguments will start the process with the default configuration file, typically\n          located at /etc/metricbeat/metricbeat.yml. This file specifies the metrics to be collected and where\n          to ship them to.\n\n          Now explain this process to me.\n          Process: ${e}\n          Explanation:\n            `,role:"user"}]}),[o.a.ExplainLogSpike]:l({params:n.type({significantFieldValues:h}),messages:({significantFieldValues:e})=>{const t=e.map((e=>Object.values(e).join(","))).join("\n");return[r,{content:`You are an observability expert using Elastic Observability Suite on call being consulted about a log threshold alert that got triggered by a spike of log messages. Your job is to take immediate action and proceed with both urgency and precision.\n      "Explain Log Rate Spikes" is an AIOps feature that uses advanced statistical methods to identify reasons for increases in log rates. It makes it easy to find and investigate causes of unusual spikes by using the analysis workflow view.\n      You are using "Explain Log Rate Spikes" and ran the statistical analysis on the log messages which occured during the alert.\n      You received the following analysis results from "Explain Log Rate Spikes" which list statistically significant co-occuring field/value combinations sorted from most significant (lower p-values) to least significant (higher p-values) that contribute to the log messages spike:\n\n      Field name,Field value,Doc count,p-value\n      ${t}\n\n      Based on the above analysis results and your observability expert knowledge, output the following:\n      Analyse the type of these logs and explain their usual purpose (1 paragraph).\n      Based on the type of these logs do a root cause analysis on why the field and value combinations from the anlaysis results are causing this spike in logs (2 parapraphs).\n      Recommend concrete remediations to resolve the root cause (3 bullet points).\n      Do not repeat the given instructions in your output.`,role:"user"}]}})}}}]);