"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAIConfig = exports.observabilityCoPilotConfig = exports.azureOpenAIConfig = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openAIConfig = _configSchema.schema.object({
  openAI: _configSchema.schema.object({
    model: _configSchema.schema.string(),
    apiKey: _configSchema.schema.string()
  })
});
exports.openAIConfig = openAIConfig;
const azureOpenAIConfig = _configSchema.schema.object({
  azureOpenAI: _configSchema.schema.object({
    resourceName: _configSchema.schema.string(),
    deploymentId: _configSchema.schema.string(),
    apiKey: _configSchema.schema.string()
  })
});
exports.azureOpenAIConfig = azureOpenAIConfig;
const observabilityCoPilotConfig = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  feedback: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    url: _configSchema.schema.string({
      defaultValue: `https://0d0uj24psl.execute-api.us-east-1.amazonaws.com/gaifeedback`
    })
  }),
  provider: _configSchema.schema.oneOf([openAIConfig, azureOpenAIConfig])
});
exports.observabilityCoPilotConfig = observabilityCoPilotConfig;