"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetCompositeSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetCompositeSLO {
  constructor(compositeSloRepository, summaryClient) {
    this.compositeSloRepository = compositeSloRepository;
    this.summaryClient = summaryClient;
  }
  async execute(compositeSloId) {
    const compositeSlo = await this.compositeSloRepository.findById(compositeSloId);
    const summaryByCompositeSlo = await this.summaryClient.fetchSummary([compositeSlo]);
    return toResponse(compositeSlo, summaryByCompositeSlo[compositeSlo.id]);
  }
}
exports.GetCompositeSLO = GetCompositeSLO;
function toResponse(compositeSlo, summary) {
  return {
    ..._sloSchema.compositeSLOResponseSchema.encode(compositeSlo),
    summary
  };
}