"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindCompositeSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _composite_slo_repository = require("./composite_slo_repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE = 1;
const DEFAULT_PER_PAGE = 25;
class FindCompositeSLO {
  constructor(repository, summaryClient) {
    this.repository = repository;
    this.summaryClient = summaryClient;
  }
  async execute(params) {
    const pagination = toPagination(params);
    const criteria = toCriteria(params);
    const sort = toSort(params);
    const {
      results: compositeSloList,
      ...resultMeta
    } = await this.repository.find(criteria, sort, pagination);
    const summaryByCompositeSlo = await this.summaryClient.fetchSummary(compositeSloList);
    return _sloSchema.findCompositeSLOResponseSchema.encode({
      page: resultMeta.page,
      perPage: resultMeta.perPage,
      total: resultMeta.total,
      results: compositeSloList.map(compositeSlo => ({
        ...compositeSlo,
        summary: summaryByCompositeSlo[compositeSlo.id]
      }))
    });
  }
}
exports.FindCompositeSLO = FindCompositeSLO;
function toCriteria(params) {
  return {
    name: params.name
  };
}
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 1 ? perPage : DEFAULT_PER_PAGE
  };
}
function toSort(params) {
  return {
    field: _composite_slo_repository.SortField.CreationTime,
    direction: params.sortDirection === 'desc' ? _composite_slo_repository.SortDirection.Desc : _composite_slo_repository.SortDirection.Asc
  };
}