"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCompositeSLO = void 0;
var _uuid = require("uuid");
var _composite_slo = require("../../domain/services/composite_slo");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CreateCompositeSLO {
  constructor(compositeSloRepository, sloRepository) {
    this.compositeSloRepository = compositeSloRepository;
    this.sloRepository = sloRepository;
  }
  async execute(params) {
    const compositeSlo = toCompositeSLO(params);
    const sloList = await this.sloRepository.findAllByIds(compositeSlo.sources.map(slo => slo.id));
    (0, _composite_slo.validateCompositeSLO)(compositeSlo, sloList);
    await this.compositeSloRepository.save(compositeSlo, {
      throwOnConflict: true
    });
    return toResponse(compositeSlo);
  }
}
exports.CreateCompositeSLO = CreateCompositeSLO;
function toCompositeSLO(params) {
  var _params$id, _params$tags;
  const now = new Date();
  return {
    ...params,
    id: (_params$id = params.id) !== null && _params$id !== void 0 ? _params$id : (0, _uuid.v1)(),
    tags: (_params$tags = params.tags) !== null && _params$tags !== void 0 ? _params$tags : [],
    createdAt: now,
    updatedAt: now
  };
}
function toResponse(compositeSlo) {
  return {
    id: compositeSlo.id
  };
}