"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityCoPilotRouteRepository = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _axios = _interopRequireDefault(require("axios"));
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _openai = require("openai");
var _prompts = require("../../../common/co_pilot/prompts");
var _create_observability_server_route = require("../create_observability_server_route");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const promptRoutes = Object.assign({}, ...(0, _lodash.map)(_prompts.coPilotPrompts, (prompt, promptId) => {
  return (0, _create_observability_server_route.createObservabilityServerRoute)({
    endpoint: `POST /internal/observability/copilot/prompts/${promptId}`,
    params: t.type({
      body: prompt.params
    }),
    options: {
      tags: ['ai_assistant']
    },
    handler: async resources => {
      const client = resources.dependencies.getOpenAIClient();
      if (!client) {
        throw _boom.default.notImplemented();
      }
      try {
        return await client.chatCompletion.create(prompt.messages(resources.params.body));
      } catch (error) {
        var _error$response;
        if (_axios.default.isAxiosError(error) && ((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 401) {
          var _error$response2;
          throw _boom.default.forbidden((_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.statusText);
        }
        throw error;
      }
    }
  });
}));
const trackRoute = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: 'POST /internal/observability/copilot/prompts/{promptId}/track',
  params: t.type({
    path: t.type({
      promptId: t.string
    }),
    body: t.intersection([t.type({
      responseTime: t.number,
      messages: t.array(t.intersection([t.type({
        role: t.union([t.literal(_openai.ChatCompletionRequestMessageRoleEnum.System), t.literal(_openai.ChatCompletionRequestMessageRoleEnum.User), t.literal(_openai.ChatCompletionRequestMessageRoleEnum.Assistant)]),
        content: t.string
      }), t.partial({
        name: t.string
      })])),
      response: t.string
    }), t.partial({
      feedbackAction: t.union([t.literal('thumbsup'), t.literal('thumbsdown')])
    })])
  }),
  options: {
    tags: ['ai_assistant']
  },
  handler: async resources => {
    var _config$aiAssistant;
    const {
      params,
      config
    } = resources;
    if (!((_config$aiAssistant = config.aiAssistant) !== null && _config$aiAssistant !== void 0 && _config$aiAssistant.enabled)) {
      throw _boom.default.notImplemented();
    }
    const feedbackBody = {
      prompt_name: params.path.promptId,
      feedback_action: params.body.feedbackAction,
      model: 'openAI' in config.aiAssistant.provider ? config.aiAssistant.provider.openAI.model : config.aiAssistant.provider.azureOpenAI.resourceName,
      response_time: params.body.responseTime,
      conversation: [...params.body.messages.map(({
        role,
        content
      }) => ({
        role,
        content
      })), {
        role: 'system',
        content: params.body.response
      }]
    };
    await _axios.default.post(config.aiAssistant.feedback.url, feedbackBody);
  }
});
const observabilityCoPilotRouteRepository = {
  ...promptRoutes,
  ...trackRoute
};
exports.observabilityCoPilotRouteRepository = observabilityCoPilotRouteRepository;