"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _common = require("@kbn/cases-plugin/common");
var _kubernetes_guide_config = require("../common/guided_onboarding/kubernetes_guide_config");
var _bootstrap_annotations = require("./lib/annotations/bootstrap_annotations");
var _ui_settings = require("./ui_settings");
var _register_routes = require("./routes/register_routes");
var _get_global_observability_server_route_repository = require("./routes/get_global_observability_server_route_repository");
var _saved_objects2 = require("./saved_objects");
var _alerts = require("../common/locators/alerts");
var _common2 = require("../common");
var _register_rule_types = require("./lib/rules/register_rule_types");
var _constants = require("../common/constants");
var _register = require("./lib/collectors/register");
var _openai = require("./services/openai");
var _threshold = require("./saved_objects/threshold");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    var _config$aiAssistant;
    const casesCapabilities = (0, _common.createUICapabilities)();
    const casesApiTags = (0, _common.getApiTags)(_common2.observabilityFeatureId);
    const config = this.initContext.config.get();
    const alertsLocator = plugins.share.url.locators.create(new _alerts.AlertsLocatorDefinition());
    plugins.features.registerKibanaFeature({
      id: _common2.casesFeatureId,
      name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitle', {
        defaultMessage: 'Cases'
      }),
      order: 1100,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common2.casesFeatureId, 'kibana'],
      catalogue: [_common2.observabilityFeatureId],
      cases: [_common2.observabilityFeatureId],
      privileges: {
        all: {
          api: casesApiTags.all,
          app: [_common2.casesFeatureId, 'kibana'],
          catalogue: [_common2.observabilityFeatureId],
          cases: {
            create: [_common2.observabilityFeatureId],
            read: [_common2.observabilityFeatureId],
            update: [_common2.observabilityFeatureId],
            push: [_common2.observabilityFeatureId]
          },
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          ui: casesCapabilities.all
        },
        read: {
          api: casesApiTags.read,
          app: [_common2.casesFeatureId, 'kibana'],
          catalogue: [_common2.observabilityFeatureId],
          cases: {
            read: [_common2.observabilityFeatureId]
          },
          savedObject: {
            all: [],
            read: [..._saved_objects.hiddenTypes]
          },
          ui: casesCapabilities.read
        }
      },
      subFeatures: [{
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureName', {
          defaultMessage: 'Delete'
        }),
        privilegeGroups: [{
          groupType: 'independent',
          privileges: [{
            api: casesApiTags.delete,
            id: 'cases_delete',
            name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureDetails', {
              defaultMessage: 'Delete cases and comments'
            }),
            includeIn: 'all',
            savedObject: {
              all: [..._saved_objects.hiddenTypes],
              read: [..._saved_objects.hiddenTypes]
            },
            cases: {
              delete: [_common2.observabilityFeatureId]
            },
            ui: casesCapabilities.delete
          }]
        }]
      }]
    });
    let annotationsApiPromise;
    core.uiSettings.register(_ui_settings.uiSettings);
    if (config.annotations.enabled) {
      annotationsApiPromise = (0, _bootstrap_annotations.bootstrapAnnotations)({
        core,
        index: config.annotations.index,
        context: this.initContext
      }).catch(err => {
        const logger = this.initContext.logger.get('annotations');
        logger.warn(err);
        throw err;
      });
    }
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    const savedObjectTypes = config.compositeSlo.enabled ? [_saved_objects2.SO_SLO_TYPE, _saved_objects2.SO_COMPOSITE_SLO_TYPE] : [_saved_objects2.SO_SLO_TYPE];
    plugins.features.registerKibanaFeature({
      id: _common2.sloFeatureId,
      name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkSloTitle', {
        defaultMessage: 'SLOs'
      }),
      order: 1200,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common2.sloFeatureId, 'kibana'],
      catalogue: [_common2.sloFeatureId, 'observability'],
      alerting: [_constants.SLO_BURN_RATE_RULE_TYPE_ID],
      privileges: {
        all: {
          app: [_common2.sloFeatureId, 'kibana'],
          catalogue: [_common2.sloFeatureId, 'observability'],
          api: ['slo_write', 'slo_read', 'rac'],
          savedObject: {
            all: savedObjectTypes,
            read: []
          },
          alerting: {
            rule: {
              all: [_constants.SLO_BURN_RATE_RULE_TYPE_ID]
            },
            alert: {
              all: [_constants.SLO_BURN_RATE_RULE_TYPE_ID]
            }
          },
          ui: ['read', 'write']
        },
        read: {
          app: [_common2.sloFeatureId, 'kibana'],
          catalogue: [_common2.sloFeatureId, 'observability'],
          api: ['slo_read', 'rac'],
          savedObject: {
            all: [],
            read: savedObjectTypes
          },
          alerting: {
            rule: {
              read: [_constants.SLO_BURN_RATE_RULE_TYPE_ID]
            },
            alert: {
              read: [_constants.SLO_BURN_RATE_RULE_TYPE_ID]
            }
          },
          ui: ['read']
        }
      }
    });
    core.savedObjects.registerType(_saved_objects2.slo);
    if (config.compositeSlo.enabled) {
      core.savedObjects.registerType(_saved_objects2.compositeSlo);
    }
    core.savedObjects.registerType(_threshold.threshold);
    (0, _register_rule_types.registerRuleTypes)(plugins.alerting, this.logger, ruleDataService, core.http.basePath, config, alertsLocator);
    (0, _register.registerSloUsageCollector)(plugins.usageCollection);
    const openAIService = (_config$aiAssistant = config.aiAssistant) !== null && _config$aiAssistant !== void 0 && _config$aiAssistant.enabled ? new _openai.OpenAIService(config.aiAssistant) : undefined;
    core.getStartServices().then(([coreStart, pluginStart]) => {
      (0, _register_routes.registerRoutes)({
        core,
        config,
        dependencies: {
          pluginsSetup: {
            ...plugins,
            core
          },
          ruleDataService,
          getRulesClientWithRequest: pluginStart.alerting.getRulesClientWithRequest,
          getOpenAIClient: () => openAIService === null || openAIService === void 0 ? void 0 : openAIService.client
        },
        logger: this.logger,
        repository: (0, _get_global_observability_server_route_repository.getObservabilityServerRouteRepository)(config)
      });
    });

    /**
     * Register a config for the observability guide
     */
    plugins.guidedOnboarding.registerGuideConfig(_kubernetes_guide_config.kubernetesGuideId, _kubernetes_guide_config.kubernetesGuideConfig);
    return {
      getAlertDetailsConfig() {
        return config.unsafe.alertDetails;
      },
      getScopedAnnotationsClient: async (...args) => {
        const api = await annotationsApiPromise;
        return api === null || api === void 0 ? void 0 : api.getScopedAnnotationsClient(...args);
      },
      getOpenAIClient() {
        return openAIService === null || openAIService === void 0 ? void 0 : openAIService.client;
      },
      alertsLocator
    };
  }
  start() {}
  stop() {}
}
exports.ObservabilityPlugin = ObservabilityPlugin;