"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPercentileAggregation = void 0;
var _types = require("../../../../../common/threshold_rule/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPercentileAggregation = (type, field) => {
  const value = type === _types.Aggregators.P95 ? 95 : 99;
  return {
    aggregatedValue: {
      percentiles: {
        field,
        percents: [value],
        keyed: true
      }
    }
  };
};
exports.createPercentileAggregation = createPercentileAggregation;