"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRuleTypes = registerRuleTypes;
var _server = require("@kbn/rule-registry-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _common2 = require("../../../common");
var _constants = require("../../common/constants");
var _slo_burn_rate = require("./slo_burn_rate");
var _register_threshold_rule_type = require("./threshold/register_threshold_rule_type");
var _field_map = require("./slo_burn_rate/field_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRuleTypes(alertingPlugin, logger, ruleDataService, basePath, config, alertsLocator) {
  // SLO RULE
  const ruleDataClientSLO = ruleDataService.initializeIndex({
    feature: _common2.sloFeatureId,
    registrationContext: _constants.SLO_RULE_REGISTRATION_CONTEXT,
    dataset: _server.Dataset.alerts,
    componentTemplateRefs: [],
    componentTemplates: [{
      name: 'mappings',
      mappings: (0, _common.mappingFromFieldMap)({
        ..._alertsAsDataUtils.legacyExperimentalFieldMap,
        ..._field_map.sloRuleFieldMap
      }, 'strict')
    }]
  });
  const createLifecycleRuleExecutorSLO = (0, _server.createLifecycleExecutor)(logger.get('rules'), ruleDataClientSLO);
  alertingPlugin.registerType((0, _slo_burn_rate.sloBurnRateRuleType)(createLifecycleRuleExecutorSLO, basePath, alertsLocator));

  // Threshold RULE
  if (config.unsafe.thresholdRule.enabled) {
    const ruleDataClientThreshold = ruleDataService.initializeIndex({
      feature: _common2.observabilityFeatureId,
      registrationContext: _constants.THRESHOLD_RULE_REGISTRATION_CONTEXT,
      dataset: _server.Dataset.alerts,
      componentTemplateRefs: [],
      componentTemplates: [{
        name: 'mappings',
        mappings: (0, _common.mappingFromFieldMap)({
          ..._alertsAsDataUtils.legacyExperimentalFieldMap
        }, 'strict')
      }]
    });
    const createLifecycleRuleExecutorThreshold = (0, _server.createLifecycleExecutor)(logger.get('rules'), ruleDataClientThreshold);
    alertingPlugin.registerType((0, _register_threshold_rule_type.thresholdRuleType)(createLifecycleRuleExecutorThreshold, basePath, config, logger, ruleDataClientThreshold));
  }
}