"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAlertEvaluationValue = void 0;
var _formatters = require("../../common/utils/formatters");
var _get_alert_evaluation_unit_type_by_rule_type_id = require("./get_alert_evaluation_unit_type_by_rule_type_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatAlertEvaluationValue = (ruleTypeId, evaluationValue) => {
  if (!evaluationValue || !ruleTypeId) return '-';
  const unitType = (0, _get_alert_evaluation_unit_type_by_rule_type_id.getAlertEvaluationUnitTypeByRuleTypeId)(ruleTypeId);
  switch (unitType) {
    case _get_alert_evaluation_unit_type_by_rule_type_id.ALERT_EVALUATION_UNIT_TYPE.DURATION:
      return (0, _formatters.asMillisecondDuration)(evaluationValue);
    case _get_alert_evaluation_unit_type_by_rule_type_id.ALERT_EVALUATION_UNIT_TYPE.PERCENT:
      return (0, _formatters.asPercent)(evaluationValue, 100);
    default:
      return evaluationValue;
  }
};
exports.formatAlertEvaluationValue = formatAlertEvaluationValue;