"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/cases-plugin/public");
var _rules = require("./locators/rules");
var _rule_details = require("./locators/rule_details");
var _slo_details = require("./locators/slo_details");
var _slo_edit = require("./locators/slo_edit");
var _common = require("../common");
var _data_handler = require("./context/has_data_context/data_handler");
var _create_observability_rule_type_registry = require("./rules/create_observability_rule_type_registry");
var _create_use_rules_link = require("./hooks/create_use_rules_link");
var _register_observability_rule_types = require("./rules/register_observability_rule_types");
var _create_co_pilot_service = require("./context/co_pilot_context/create_co_pilot_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class Plugin {
  // Define deep links as constant and hidden. Whether they are shown or hidden
  // in the global navigation will happen in `updateGlobalNavigation`.

  constructor(initContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "observabilityRuleTypeRegistry", {});
    (0, _defineProperty2.default)(this, "coPilotService", void 0);
    (0, _defineProperty2.default)(this, "deepLinks", [{
      id: 'alerts',
      title: _i18n.i18n.translate('xpack.observability.alertsLinkTitle', {
        defaultMessage: 'Alerts'
      }),
      order: 8001,
      path: '/alerts',
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      deepLinks: [{
        id: 'rules',
        title: _i18n.i18n.translate('xpack.observability.rulesLinkTitle', {
          defaultMessage: 'Rules'
        }),
        path: '/alerts/rules',
        navLinkStatus: _public.AppNavLinkStatus.hidden
      }]
    }, {
      id: 'slos',
      title: _i18n.i18n.translate('xpack.observability.slosLinkTitle', {
        defaultMessage: 'SLOs'
      }),
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      order: 8002,
      path: '/slos'
    }, (0, _public2.getCasesDeepLinks)({
      basePath: _common.casesPath,
      extend: {
        [_public2.CasesDeepLinkId.cases]: {
          order: 8003,
          navLinkStatus: _public.AppNavLinkStatus.hidden
        },
        [_public2.CasesDeepLinkId.casesCreate]: {
          navLinkStatus: _public.AppNavLinkStatus.hidden,
          searchable: false
        },
        [_public2.CasesDeepLinkId.casesConfigure]: {
          navLinkStatus: _public.AppNavLinkStatus.hidden,
          searchable: false
        }
      }
    })]);
    this.initContext = initContext;
  }
  setup(coreSetup, pluginsSetup) {
    var _config$aiAssistant, _config$aiAssistant2;
    const category = _public.DEFAULT_APP_CATEGORIES.observability;
    const euiIconType = 'logoObservability';
    const config = this.initContext.config.get();
    const kibanaVersion = this.initContext.env.packageInfo.version;
    this.observabilityRuleTypeRegistry = (0, _create_observability_rule_type_registry.createObservabilityRuleTypeRegistry)(pluginsSetup.triggersActionsUi.ruleTypeRegistry);
    const rulesLocator = pluginsSetup.share.url.locators.create(new _rules.RulesLocatorDefinition());
    const ruleDetailsLocator = pluginsSetup.share.url.locators.create(new _rule_details.RuleDetailsLocatorDefinition());
    const sloDetailsLocator = pluginsSetup.share.url.locators.create(new _slo_details.SloDetailsLocatorDefinition());
    const sloEditLocator = pluginsSetup.share.url.locators.create(new _slo_edit.SloEditLocatorDefinition());
    const mount = async params => {
      // Load application bundle
      const {
        renderApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      // Get start services
      const [coreStart, pluginsStart] = await coreSetup.getStartServices();
      const {
        ruleTypeRegistry,
        actionTypeRegistry
      } = pluginsStart.triggersActionsUi;
      return renderApp({
        core: coreStart,
        config,
        plugins: {
          ...pluginsStart,
          ruleTypeRegistry,
          actionTypeRegistry
        },
        appMountParameters: params,
        observabilityRuleTypeRegistry: this.observabilityRuleTypeRegistry,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        usageCollection: pluginsSetup.usageCollection,
        isDev: this.initContext.env.mode.dev,
        kibanaVersion
      });
    };
    const appUpdater$ = this.appUpdater$;
    const app = {
      appRoute: '/app/observability',
      category,
      deepLinks: this.deepLinks,
      euiIconType,
      id: _common.observabilityAppId,
      mount,
      order: 8000,
      title: _i18n.i18n.translate('xpack.observability.overviewLinkTitle', {
        defaultMessage: 'Overview'
      }),
      updater$: appUpdater$,
      keywords: ['observability', 'monitor', 'logs', 'metrics', 'apm', 'slo', 'performance', 'trace', 'agent', 'rum', 'user', 'experience']
    };
    coreSetup.application.register(app);
    (0, _register_observability_rule_types.registerObservabilityRuleTypes)(config, this.observabilityRuleTypeRegistry);
    if (pluginsSetup.home) {
      pluginsSetup.home.featureCatalogue.registerSolution({
        id: _common.observabilityFeatureId,
        title: _i18n.i18n.translate('xpack.observability.featureCatalogueTitle', {
          defaultMessage: 'Observability'
        }),
        description: _i18n.i18n.translate('xpack.observability.featureCatalogueDescription', {
          defaultMessage: 'Consolidate your logs, metrics, application traces, and system availability with purpose-built UIs.'
        }),
        icon: 'logoObservability',
        path: '/app/observability/',
        order: 200
      });
    }
    pluginsSetup.observabilityShared.navigation.registerSections((0, _rxjs.from)(appUpdater$).pipe((0, _operators.map)(value => {
      var _value$deepLinks, _value;
      const deepLinks = (_value$deepLinks = (_value = value(app)) === null || _value === void 0 ? void 0 : _value.deepLinks) !== null && _value$deepLinks !== void 0 ? _value$deepLinks : [];
      const overviewLink = {
        label: _i18n.i18n.translate('xpack.observability.overviewLinkTitle', {
          defaultMessage: 'Overview'
        }),
        app: _common.observabilityAppId,
        path: '/overview'
      };

      // Reformat the visible links to be NavigationEntry objects instead of
      // AppDeepLink objects.
      //
      // In our case the deep links and sections being registered are the
      // same, and the logic to hide them based on flags or capabilities is
      // the same, so we just want to make a new list with the properties
      // needed by `registerSections`, which are different than the
      // properties used by the deepLinks.
      //
      // See https://github.com/elastic/kibana/issues/103325.
      const otherLinks = deepLinks.filter(link => link.navLinkStatus === _public.AppNavLinkStatus.visible).map(link => {
        var _link$path;
        return {
          app: _common.observabilityAppId,
          label: link.title,
          path: (_link$path = link.path) !== null && _link$path !== void 0 ? _link$path : ''
        };
      });
      const sections = [{
        label: '',
        sortKey: 100,
        entries: [overviewLink, ...otherLinks]
      }];
      return sections;
    })));
    this.coPilotService = (0, _create_co_pilot_service.createCoPilotService)({
      enabled: !!((_config$aiAssistant = config.aiAssistant) !== null && _config$aiAssistant !== void 0 && _config$aiAssistant.enabled),
      http: coreSetup.http,
      trackingEnabled: !!((_config$aiAssistant2 = config.aiAssistant) !== null && _config$aiAssistant2 !== void 0 && _config$aiAssistant2.feedback.enabled)
    });
    return {
      dashboard: {
        register: _data_handler.registerDataHandler
      },
      observabilityRuleTypeRegistry: this.observabilityRuleTypeRegistry,
      useRulesLink: (0, _create_use_rules_link.createUseRulesLink)(),
      rulesLocator,
      ruleDetailsLocator,
      sloDetailsLocator,
      sloEditLocator,
      getCoPilotService: () => this.coPilotService
    };
  }
  start(coreStart, pluginsStart) {
    const {
      application
    } = coreStart;
    const config = this.initContext.config.get();
    pluginsStart.observabilityShared.updateGlobalNavigation({
      capabilities: application.capabilities,
      deepLinks: this.deepLinks,
      updater$: this.appUpdater$
    });
    const getAsyncO11yAlertsTableConfiguration = async () => {
      const {
        getAlertsTableConfiguration
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/alerts_table/get_alerts_table_configuration')));
      return getAlertsTableConfiguration(this.observabilityRuleTypeRegistry, config);
    };
    const {
      alertsTableConfigurationRegistry
    } = pluginsStart.triggersActionsUi;
    getAsyncO11yAlertsTableConfiguration().then(alertsTableConfig => {
      alertsTableConfigurationRegistry.register(alertsTableConfig);
    });
    return {
      observabilityRuleTypeRegistry: this.observabilityRuleTypeRegistry,
      useRulesLink: (0, _create_use_rules_link.createUseRulesLink)(),
      getCoPilotService: () => this.coPilotService
    };
  }
}
exports.Plugin = Plugin;