"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloList = SloList;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactQuery = require("@tanstack/react-query");
var _use_fetch_slo_list = require("../../../hooks/slo/use_fetch_slo_list");
var _slo_list_search_filter_sort_bar = require("./slo_list_search_filter_sort_bar");
var _slo_list_items = require("./slo_list_items");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloList({
  autoRefresh
}) {
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [query, setQuery] = (0, _react.useState)('');
  const [sort, setSort] = (0, _react.useState)('creationTime');
  const [indicatorTypeFilter, setIndicatorTypeFilter] = (0, _react.useState)([]);
  const {
    isInitialLoading,
    isLoading,
    isRefetching,
    isError,
    sloList,
    refetch
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    page: activePage + 1,
    name: query,
    sortBy: sort,
    indicatorTypes: indicatorTypeFilter,
    shouldRefetch: autoRefresh
  });
  const {
    results = [],
    total = 0,
    perPage = 0
  } = sloList || {};
  const isCreatingSlo = Boolean((0, _reactQuery.useIsMutating)(['creatingSlo']));
  const isCloningSlo = Boolean((0, _reactQuery.useIsMutating)(['cloningSlo']));
  const isUpdatingSlo = Boolean((0, _reactQuery.useIsMutating)(['updatingSlo']));
  const isDeletingSlo = Boolean((0, _reactQuery.useIsMutating)(['deleteSlo']));
  const handlePageClick = pageNumber => {
    setActivePage(pageNumber);
    refetch();
  };
  const handleChangeQuery = (0, _react.useMemo)(() => (0, _lodash.debounce)(e => {
    setQuery(e.target.value);
  }, 300), []);
  const handleChangeSort = newSort => {
    setSort(newSort);
  };
  const handleChangeIndicatorTypeFilter = newFilter => {
    setIndicatorTypeFilter(newFilter);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "sloList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_list_search_filter_sort_bar.SloListSearchFilterSortBar, {
    loading: isInitialLoading || isLoading || isRefetching || isCreatingSlo || isCloningSlo || isUpdatingSlo || isDeletingSlo,
    onChangeQuery: handleChangeQuery,
    onChangeSort: handleChangeSort,
    onChangeIndicatorTypeFilter: handleChangeIndicatorTypeFilter
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_list_items.SloListItems, {
    sloList: results,
    loading: isLoading || isRefetching,
    error: isError
  })), results.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: Math.ceil(total / perPage),
    activePage: activePage,
    onPageClick: handlePageClick
  })))) : null);
}