"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = AutoRefreshButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AutoRefreshButton({
  dataTestSubj = 'autoRefreshButton',
  disabled,
  isAutoRefreshing,
  onClick
}) {
  return isAutoRefreshing ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    iconSide: "left",
    iconType: "pause",
    onClick: onClick
  }, _i18n.i18n.translate('xpack.observability.slosPage.stopRefreshingButtonLabel', {
    defaultMessage: 'Stop refreshing'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    iconSide: "left",
    iconType: "play",
    onClick: onClick
  }, _i18n.i18n.translate('xpack.observability.slosPage.autoRefreshButtonLabel', {
    defaultMessage: 'Auto-refresh'
  }));
}