"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricIndicator = MetricIndicator;
exports.NEW_CUSTOM_METRIC = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_CUSTOM_METRIC = {
  name: 'A',
  aggregation: 'sum',
  field: ''
};
exports.NEW_CUSTOM_METRIC = NEW_CUSTOM_METRIC;
const MAX_VARIABLES = 26;
const CHAR_CODE_FOR_A = 65;
const CHAR_CODE_FOR_Z = CHAR_CODE_FOR_A + MAX_VARIABLES;
const VAR_NAMES = (0, _lodash.range)(CHAR_CODE_FOR_A, CHAR_CODE_FOR_Z).map(c => String.fromCharCode(c));
const INVALID_EQUATION_REGEX = /[^A-Z|+|\-|\s|\d+|\.|\(|\)|\/|\*|>|<|=|\?|\:|&|\!|\|]+/;
const validateEquation = value => {
  const result = value.match(INVALID_EQUATION_REGEX);
  return result === null;
};
function createOptions(fields) {
  return fields.map(field => ({
    label: field.name,
    value: field.name
  })).sort((a, b) => String(a.label).localeCompare(b.label));
}
function createEquationFromMetric(names) {
  return names.join(' + ');
}
function MetricIndicator({
  type,
  indexFields,
  isLoadingIndex,
  metricLabel,
  equationLabel,
  metricTooltip,
  equationTooltip
}) {
  const {
    control,
    watch,
    setValue,
    register
  } = (0, _reactHookForm.useFormContext)();
  const metricFields = (indexFields !== null && indexFields !== void 0 ? indexFields : []).filter(field => field.type === 'number');
  const {
    fields,
    append,
    remove
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: `indicator.params.${type}.metrics`
  });
  const equation = watch(`indicator.params.${type}.equation`);
  const indexPattern = watch('indicator.params.index');
  const disableAdd = (fields === null || fields === void 0 ? void 0 : fields.length) === MAX_VARIABLES;
  const disableDelete = (fields === null || fields === void 0 ? void 0 : fields.length) === 1;
  const setDefaultEquationIfUnchanged = (previousNames, nextNames) => {
    const defaultEquation = createEquationFromMetric(previousNames);
    if (defaultEquation === equation) {
      setValue(`indicator.params.${type}.equation`, createEquationFromMetric(nextNames));
    }
  };
  const handleDeleteMetric = index => () => {
    var _fields$map;
    const currentVars = (_fields$map = fields.map(m => m.name)) !== null && _fields$map !== void 0 ? _fields$map : ['A'];
    const deletedVar = currentVars[index];
    setDefaultEquationIfUnchanged(currentVars, (0, _lodash.xor)(currentVars, [deletedVar]));
    remove(index);
  };
  const handleAddMetric = () => {
    var _fields$map2;
    const currentVars = (_fields$map2 = fields.map(m => m.name)) !== null && _fields$map2 !== void 0 ? _fields$map2 : ['A'];
    const name = (0, _lodash.first)((0, _lodash.xor)(VAR_NAMES, currentVars));
    setDefaultEquationIfUnchanged(currentVars, [...currentVars, name]);
    append({
      ...NEW_CUSTOM_METRIC,
      name
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, fields === null || fields === void 0 ? void 0 : fields.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement("span", null, metricLabel, " ", metric.name, " ", metricTooltip),
    key: metric.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
    hidden: true
  }, register(`indicator.params.${type}.metrics.${index}.name`))), /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({
    hidden: true
  }, register(`indicator.params.${type}.metrics.${index}.aggregation`))), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.metrics.${index}.field`,
    defaultValue: "",
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      prepend: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.sumLabel', {
        defaultMessage: 'Sum of'
      }),
      placeholder: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.metricField.placeholder', {
        defaultMessage: 'Select a metric field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.metricField.placeholder', {
        defaultMessage: 'Select a metric field'
      }),
      isInvalid: fieldState.invalid,
      isDisabled: !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!indexPattern && !!field.value && metricFields.some(metricField => metricField.name === field.value) ? [{
        value: field.value,
        label: field.value
      }] : [],
      options: createOptions(metricFields)
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    style: {
      marginBottom: '0.2em'
    },
    onClick: handleDeleteMetric(index),
    disabled: disableDelete,
    title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.deleteLabel', {
      defaultMessage: 'Delete metric'
    }),
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.deleteLabel', {
      defaultMessage: 'Delete metric'
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "customMetricIndicatorAddMetricButton",
    color: 'primary',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddMetric,
    isDisabled: disableAdd,
    "aria-label": _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.addMetricAriaLabel', {
      defaultMessage: 'Add metric'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slo.sloEdit.sliType.customMetric.addMetricLabel",
    defaultMessage: "Add metric"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.${type}.equation`,
    defaultValue: "",
    rules: {
      required: true,
      validate: {
        validateEquation
      }
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement("span", null, equationLabel, " ", equationTooltip),
      helpText: _i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.equationHelpText', {
        defaultMessage: 'Supports basic math equations, valid charaters are: A-Z, +, -, /, *, (, ), ?, !, &, :, |, >, <, ='
      }),
      isInvalid: fieldState.invalid,
      error: [_i18n.i18n.translate('xpack.observability.slo.sloEdit.sliType.customMetric.equation.invalidCharacters', {
        defaultMessage: 'The equation field only supports the following characters: A-Z, +, -, /, *, (, ), ?, !, &, :, |, >, <, ='
      })]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      isInvalid: fieldState.invalid,
      fullWidth: true,
      "data-test-subj": "o11yCustomMetricEquation"
    })))
  })));
}