"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBudgetChartPanel = ErrorBudgetChartPanel;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../utils/kibana_react");
var _labels = require("../../../utils/slo/labels");
var _wide_chart = require("./wide_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorBudgetChartPanel({
  data,
  isLoading,
  slo
}) {
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const isSloFailed = slo.summary.status === 'DEGRADING' || slo.summary.status === 'VIOLATED';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "errorBudgetChartPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.slo.sloDetails.errorBudgetChartPanel.title', {
    defaultMessage: 'Error budget burn down'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _sloSchema.rollingTimeWindowTypeSchema.is(slo.timeWindow.type) ? _i18n.i18n.translate('xpack.observability.slo.sloDetails.errorBudgetChartPanel.duration', {
    defaultMessage: 'Last {duration}',
    values: {
      duration: (0, _labels.toDurationLabel)(slo.timeWindow.duration)
    }
  }) : (0, _labels.toDurationAdverbLabel)(slo.timeWindow.duration)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    titleColor: isSloFailed ? 'danger' : 'success',
    title: (0, _numeral.default)(slo.summary.errorBudget.remaining).format(percentFormat),
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.observability.slo.sloDetails.errorBudgetChartPanel.remaining', {
      defaultMessage: 'Remaining'
    }),
    reverse: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_wide_chart.WideChart, {
    chart: "area",
    id: _i18n.i18n.translate('xpack.observability.slo.sloDetails.errorBudgetChartPanel.chartTitle', {
      defaultMessage: 'Error budget remaining'
    }),
    state: isSloFailed ? 'error' : 'success',
    data: data,
    isLoading: isLoading
  }))));
}