"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLOS_PATH = '/slos';
class SloEditLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.sloEditLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async slo => {
      return {
        app: 'observability',
        path: (0, _public.setStateToKbnUrl)('_a', {
          ...slo
        }, {
          useHash: false,
          storeInHashQuery: false
        }, slo.id ? `${SLOS_PATH}/edit/${encodeURI(String(slo.id))}` : `${SLOS_PATH}/create`),
        state: {}
      };
    });
  }
}
exports.SloEditLocatorDefinition = SloEditLocatorDefinition;