"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleDetailsPath = exports.RuleDetailsLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../../common");
var _constants = require("../components/alert_search_bar/constants");
var _constants2 = require("../pages/rule_details/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleDetailsPath = ruleId => {
  return `/alerts/rules/${encodeURI(ruleId)}`;
};
exports.getRuleDetailsPath = getRuleDetailsPath;
class RuleDetailsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.ruleDetailsLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        ruleId,
        kuery,
        rangeTo,
        tabId,
        rangeFrom,
        status
      } = params;
      const appState = {};
      appState.rangeFrom = rangeFrom || 'now-15m';
      appState.rangeTo = rangeTo || 'now';
      appState.kuery = kuery || '';
      appState.status = status || _constants.ALL_ALERTS.status;
      let path = getRuleDetailsPath(ruleId);
      if (tabId === _constants2.ALERTS_TAB) {
        path = `${path}?tabId=${tabId}`;
        path = (0, _public.setStateToKbnUrl)(_constants2.SEARCH_BAR_URL_STORAGE_KEY, appState, {
          useHash: false,
          storeInHashQuery: false
        }, path);
      } else if (tabId === _constants2.EXECUTION_TAB) {
        path = `${path}?tabId=${tabId}`;
      }
      return {
        app: 'observability',
        path,
        state: {}
      };
    });
  }
}
exports.RuleDetailsLocatorDefinition = RuleDetailsLocatorDefinition;