"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOCAL_STORAGE_DISMISS_GUIDED_SETUP_PROGRESS_KEY = void 0;
exports.useGuidedSetupProgress = useGuidedSetupProgress;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_DISMISS_GUIDED_SETUP_PROGRESS_KEY = 'DISMISS_GUIDED_SETUP_PROGRESS';
exports.LOCAL_STORAGE_DISMISS_GUIDED_SETUP_PROGRESS_KEY = LOCAL_STORAGE_DISMISS_GUIDED_SETUP_PROGRESS_KEY;
function useGuidedSetupProgress() {
  const dismissedGuidedSetupProgressLocalStorage = window.localStorage.getItem(LOCAL_STORAGE_DISMISS_GUIDED_SETUP_PROGRESS_KEY);
  const [isGuidedSetupProgressDismissed, setIsGuidedSetupProgressDismissed] = (0, _react.useState)(JSON.parse(dismissedGuidedSetupProgressLocalStorage || 'false'));
  const dismissGuidedSetupProgress = (0, _react.useCallback)(() => {
    window.localStorage.setItem(LOCAL_STORAGE_DISMISS_GUIDED_SETUP_PROGRESS_KEY, 'true');
    setIsGuidedSetupProgressDismissed(true);
  }, []);
  return {
    isGuidedSetupProgressDismissed,
    dismissGuidedSetupProgress
  };
}