"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetPreviewData = useGetPreviewData;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetPreviewData(indicator) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.preview(indicator),
    queryFn: async ({
      signal
    }) => {
      const response = await http.post('/internal/observability/slos/_preview', {
        body: JSON.stringify({
          indicator
        }),
        signal
      });
      return response;
    },
    retry: false,
    refetchOnWindowFocus: false,
    enabled: Boolean(indicator)
  });
  return {
    data,
    isLoading,
    isRefetching,
    isInitialLoading,
    isSuccess,
    isError,
    refetch
  };
}