"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchHistoricalSummary = void 0;
var _historical_summary_data = require("../../../data/slo/historical_summary_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchHistoricalSummary = ({
  sloIds = []
}) => {
  const data = {};
  sloIds.forEach(sloId => data[sloId] = _historical_summary_data.historicalSummaryData[_historical_summary_data.HEALTHY_ROLLING_SLO]);
  return {
    isLoading: false,
    isInitialLoading: false,
    isRefetching: false,
    isSuccess: false,
    isError: false,
    sloHistoricalSummaryResponse: data
  };
};
exports.useFetchHistoricalSummary = useFetchHistoricalSummary;