"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCoPilotService = createCoPilotService;
var _rxjs = require("rxjs");
var _co_pilot = require("../../../common/co_pilot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getMessageFromChunks(chunks) {
  let message = '';
  chunks.forEach(chunk => {
    var _chunk$choices$0$delt, _chunk$choices$;
    message += (_chunk$choices$0$delt = (_chunk$choices$ = chunk.choices[0]) === null || _chunk$choices$ === void 0 ? void 0 : _chunk$choices$.delta.content) !== null && _chunk$choices$0$delt !== void 0 ? _chunk$choices$0$delt : '';
  });
  return message;
}
function createCoPilotService({
  enabled,
  trackingEnabled,
  http
}) {
  const service = {
    isEnabled: () => enabled,
    isTrackingEnabled: () => trackingEnabled,
    prompt: (promptId, params) => {
      const subject = new _rxjs.BehaviorSubject({
        messages: [],
        loading: true,
        message: ''
      });
      (0, _co_pilot.loadCoPilotPrompts)().then(coPilotPrompts => {
        const messages = coPilotPrompts[promptId].messages(params);
        subject.next({
          messages,
          loading: true,
          message: ''
        });
        http.post(`/internal/observability/copilot/prompts/${promptId}`, {
          body: JSON.stringify(params),
          asResponse: true,
          rawResponse: true
        }).then(response => {
          var _response$response, _response$response$bo;
          const status = (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.status;
          if (!status || status >= 400) {
            var _response$response2;
            throw new Error(((_response$response2 = response.response) === null || _response$response2 === void 0 ? void 0 : _response$response2.statusText) || 'Unexpected error');
          }
          const reader = (_response$response$bo = response.response.body) === null || _response$response$bo === void 0 ? void 0 : _response$response$bo.getReader();
          if (!reader) {
            throw new Error('Could not get reader from response');
          }
          const decoder = new TextDecoder();
          const chunks = [];
          let prev = '';
          function read() {
            reader.read().then(({
              done,
              value
            }) => {
              try {
                if (done) {
                  subject.next({
                    messages,
                    message: getMessageFromChunks(chunks),
                    loading: false
                  });
                  subject.complete();
                  return;
                }
                let lines = (prev + decoder.decode(value)).split('\n');
                const lastLine = lines[lines.length - 1];
                const isPartialChunk = !!lastLine && lastLine !== 'data: [DONE]';
                if (isPartialChunk) {
                  prev = lastLine;
                  lines.pop();
                } else {
                  prev = '';
                }
                lines = lines.map(str => str.substr(6)).filter(str => !!str && str !== '[DONE]');
                const nextChunks = lines.map(line => JSON.parse(line));
                nextChunks.forEach(chunk => {
                  chunks.push(chunk);
                  subject.next({
                    messages,
                    message: getMessageFromChunks(chunks),
                    loading: true
                  });
                });
              } catch (err) {
                subject.error(err);
                return;
              }
              read();
            });
          }
          read();
        }).catch(async err => {
          if ('response' in err) {
            try {
              const responseBody = await err.response.json();
              err.message = responseBody.message;
            } catch {
              // leave message as-is
            }
          }
          subject.error(err);
        });
      }).catch(err => {});
      return subject.pipe((0, _rxjs.concatMap)(value => (0, _rxjs.of)(value).pipe((0, _rxjs.delay)(25))));
    },
    track: async ({
      messages,
      response,
      responseTime,
      feedbackAction,
      promptId
    }) => {
      await http.post(`/internal/observability/copilot/prompts/${promptId}/track`, {
        body: JSON.stringify({
          response,
          feedbackAction,
          messages,
          responseTime
        })
      });
    }
  };
  return service;
}