"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricExplorerSeriesChart = MetricExplorerSeriesChart;
exports.MetricsExplorerAreaChart = MetricsExplorerAreaChart;
exports.MetricsExplorerBarChart = MetricsExplorerBarChart;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _color_palette = require("../../../../common/threshold_rule/color_palette");
var _types = require("../../../../common/threshold_rule/types");
var _get_metric_id = require("../helpers/get_metric_id");
var _use_kibana_time_zone_setting = require("../hooks/use_kibana_time_zone_setting");
var _create_metric_label = require("../helpers/create_metric_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricExplorerSeriesChart(props) {
  if (_types.MetricsExplorerChartType.bar === props.type) {
    return /*#__PURE__*/_react.default.createElement(MetricsExplorerBarChart, props);
  }
  return /*#__PURE__*/_react.default.createElement(MetricsExplorerAreaChart, props);
}
function MetricsExplorerAreaChart({
  metric,
  id,
  series,
  type,
  stack,
  opacity
}) {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const color = metric.color && (0, _color_palette.colorTransformer)(metric.color) || (0, _color_palette.colorTransformer)(_color_palette.Color.color0);
  const yAccessors = Array.isArray(id) ? id.map(i => (0, _get_metric_id.getMetricId)(metric, i)).slice(id.length - 1, id.length) : [(0, _get_metric_id.getMetricId)(metric, id)];
  const y0Accessors = Array.isArray(id) && id.length > 1 ? id.map(i => (0, _get_metric_id.getMetricId)(metric, i)).slice(0, 1) : undefined;
  const chartId = `series-${series.id}-${yAccessors.join('-')}`;
  const seriesAreaStyle = {
    line: {
      strokeWidth: 2,
      visible: true
    },
    area: {
      opacity: opacity || 0.5,
      visible: type === _types.MetricsExplorerChartType.area
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: chartId,
    key: chartId,
    name: (0, _create_metric_label.createMetricLabel)(metric),
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: yAccessors,
    y0Accessors: y0Accessors,
    data: series.rows,
    stackAccessors: stack ? ['timestamp'] : void 0,
    areaSeriesStyle: seriesAreaStyle,
    color: color,
    timeZone: timezone
  });
}
function MetricsExplorerBarChart({
  metric,
  id,
  series,
  stack
}) {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const color = metric.color && (0, _color_palette.colorTransformer)(metric.color) || (0, _color_palette.colorTransformer)(_color_palette.Color.color0);
  const yAccessors = Array.isArray(id) ? id.map(i => (0, _get_metric_id.getMetricId)(metric, i)).slice(id.length - 1, id.length) : [(0, _get_metric_id.getMetricId)(metric, id)];
  const chartId = `series-${series.id}-${yAccessors.join('-')}`;
  const seriesBarStyle = {
    rectBorder: {
      stroke: color,
      strokeWidth: 1,
      visible: true
    },
    rect: {
      opacity: 1
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: chartId,
    key: chartId,
    name: (0, _create_metric_label.createMetricLabel)(metric),
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: yAccessors,
    data: series.rows,
    stackAccessors: stack ? ['timestamp'] : void 0,
    barSeriesStyle: seriesBarStyle,
    color: color,
    timeZone: timezone
  });
}