"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomEquationEditor = CustomEquationEditor;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _metrics_explorer = require("../../../../../common/threshold_rule/metrics_explorer");
var _types = require("../../../../../common/threshold_rule/types");
var _metric_row_with_agg = require("./metric_row_with_agg");
var _metric_row_with_count = require("./metric_row_with_count");
var _i18n_strings = require("../../i18n_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_METRIC = {
  name: 'A',
  aggType: _types.Aggregators.AVERAGE
};
const MAX_VARIABLES = 26;
const CHAR_CODE_FOR_A = 65;
const CHAR_CODE_FOR_Z = CHAR_CODE_FOR_A + MAX_VARIABLES;
const VAR_NAMES = (0, _lodash.range)(CHAR_CODE_FOR_A, CHAR_CODE_FOR_Z).map(c => String.fromCharCode(c));
function CustomEquationEditor({
  onChange,
  expression,
  fields,
  aggregationTypes,
  errors,
  dataView
}) {
  var _expression$customMet;
  const [customMetrics, setCustomMetrics] = (0, _react.useState)((_expression$customMet = expression === null || expression === void 0 ? void 0 : expression.customMetrics) !== null && _expression$customMet !== void 0 ? _expression$customMet : [NEW_METRIC]);
  const [label, setLabel] = (0, _react.useState)((expression === null || expression === void 0 ? void 0 : expression.label) || undefined);
  const [equation, setEquation] = (0, _react.useState)((expression === null || expression === void 0 ? void 0 : expression.equation) || undefined);
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(onChange, 500), [onChange]);
  const handleAddNewRow = (0, _react.useCallback)(() => {
    setCustomMetrics(previous => {
      var _previous$map;
      const currentVars = (_previous$map = previous === null || previous === void 0 ? void 0 : previous.map(m => m.name)) !== null && _previous$map !== void 0 ? _previous$map : [];
      const name = (0, _lodash.first)((0, _lodash.xor)(VAR_NAMES, currentVars));
      const nextMetrics = [...(previous || []), {
        ...NEW_METRIC,
        name
      }];
      debouncedOnChange({
        ...expression,
        customMetrics: nextMetrics,
        equation,
        label
      });
      return nextMetrics;
    });
  }, [debouncedOnChange, equation, expression, label]);
  const handleDelete = (0, _react.useCallback)(name => {
    setCustomMetrics(previous => {
      var _previous$filter;
      const nextMetrics = (_previous$filter = previous === null || previous === void 0 ? void 0 : previous.filter(row => row.name !== name)) !== null && _previous$filter !== void 0 ? _previous$filter : [NEW_METRIC];
      const finalMetrics = nextMetrics.length && nextMetrics || [NEW_METRIC];
      debouncedOnChange({
        ...expression,
        customMetrics: finalMetrics,
        equation,
        label
      });
      return finalMetrics;
    });
  }, [equation, expression, debouncedOnChange, label]);
  const handleChange = (0, _react.useCallback)(metric => {
    setCustomMetrics(previous => {
      const nextMetrics = previous === null || previous === void 0 ? void 0 : previous.map(m => m.name === metric.name ? metric : m);
      debouncedOnChange({
        ...expression,
        customMetrics: nextMetrics,
        equation,
        label
      });
      return nextMetrics;
    });
  }, [equation, expression, debouncedOnChange, label]);
  const handleEquationChange = (0, _react.useCallback)(e => {
    setEquation(e.target.value);
    debouncedOnChange({
      ...expression,
      customMetrics,
      equation: e.target.value,
      label
    });
  }, [debouncedOnChange, expression, customMetrics, label]);
  const handleLabelChange = (0, _react.useCallback)(e => {
    setLabel(e.target.value);
    debouncedOnChange({
      ...expression,
      customMetrics,
      equation,
      label: e.target.value
    });
  }, [debouncedOnChange, expression, customMetrics, equation]);
  const disableAdd = (customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.length) === MAX_VARIABLES;
  const disableDelete = (customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.length) === 1;
  const filteredAggregationTypes = (0, _lodash.omit)(aggregationTypes, _metrics_explorer.OMITTED_AGGREGATIONS_FOR_CUSTOM_METRICS);
  const metricRows = customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.map(row => {
    if (row.aggType === _types.Aggregators.COUNT) {
      return /*#__PURE__*/_react.default.createElement(_metric_row_with_count.MetricRowWithCount, {
        key: row.name,
        name: row.name,
        agg: row.aggType,
        filter: row.filter,
        onAdd: handleAddNewRow,
        onDelete: handleDelete,
        disableAdd: disableAdd,
        aggregationTypes: filteredAggregationTypes,
        disableDelete: disableDelete,
        onChange: handleChange,
        errors: errors,
        dataView: dataView
      });
    }
    return /*#__PURE__*/_react.default.createElement(_metric_row_with_agg.MetricRowWithAgg, {
      key: row.name,
      name: row.name,
      aggType: row.aggType,
      aggregationTypes: filteredAggregationTypes,
      field: row.field,
      fields: fields,
      onAdd: handleAddNewRow,
      onDelete: handleDelete,
      disableAdd: disableAdd,
      disableDelete: disableDelete,
      onChange: handleChange,
      errors: errors
    });
  });
  const placeholder = (0, _react.useMemo)(() => {
    return customMetrics === null || customMetrics === void 0 ? void 0 : customMetrics.map(row => row.name).join(' + ');
  }, [customMetrics]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), metricRows, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleCustomEquationEditorAddAggregationFieldButton",
    color: 'primary',
    flush: 'left',
    size: "xs",
    iconType: 'plusInCircleFilled',
    onClick: handleAddNewRow,
    isDisabled: disableAdd
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.threshold.rule.alertFlyout.customEquationEditor.addCustomRow",
    defaultMessage: "Add aggregation/field"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Equation",
    fullWidth: true,
    helpText: _i18n_strings.EQUATION_HELP_MESSAGE,
    isInvalid: errors.equation != null,
    error: [errors.equation]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "thresholdRuleCustomEquationEditorFieldText",
    isInvalid: errors.equation != null,
    compressed: true,
    fullWidth: true,
    placeholder: placeholder,
    onChange: handleEquationChange,
    value: equation !== null && equation !== void 0 ? equation : ''
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n_strings.LABEL_LABEL,
    fullWidth: true,
    helpText: _i18n_strings.LABEL_HELP_MESSAGE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "thresholdRuleCustomEquationEditorFieldText",
    compressed: true,
    fullWidth: true,
    value: label,
    placeholder: _i18n_strings.CUSTOM_EQUATION,
    onChange: handleLabelChange
  })))));
}