"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AlertDetailsAppSection;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _kibana_react = require("../../../utils/kibana_react");
var _metric_value_formatter = require("../../../../common/threshold_rule/metric_value_formatter");
var _generate_unique_key = require("../lib/generate_unique_key");
var _expression_chart = require("./expression_chart");
var _criterion_preview_chart = require("./criterion_preview_chart/criterion_preview_chart");
var _threshold = require("./threshold");
var _use_metrics_explorer_options = require("../hooks/use_metrics_explorer_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_FORMAT = 'YYYY-MM-DD HH:mm';
const ALERT_START_ANNOTATION_ID = 'alert_start_annotation';
const ALERT_TIME_RANGE_ANNOTATION_ID = 'alert_time_range_annotation';
// eslint-disable-next-line import/no-default-export
function AlertDetailsAppSection({
  alert,
  rule,
  ruleLink,
  setAlertSummaryFields
}) {
  const {
    uiSettings,
    charts
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // TODO Use rule data view
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: [],
    title: 'unknown-index'
  }), []);
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  const timeRange = (0, _observabilityAlertDetails.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  const annotations = [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertAnnotation, {
    alertStart: alert.start,
    color: euiTheme.colors.danger,
    dateFormat: uiSettings.get('dateFormat') || DEFAULT_DATE_FORMAT,
    id: ALERT_START_ANNOTATION_ID,
    key: ALERT_START_ANNOTATION_ID
  }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertActiveTimeRangeAnnotation, {
    alertStart: alert.start,
    alertEnd: alertEnd,
    color: euiTheme.colors.danger,
    id: ALERT_TIME_RANGE_ANNOTATION_ID,
    key: ALERT_TIME_RANGE_ANNOTATION_ID
  })];
  (0, _react.useEffect)(() => {
    setAlertSummaryFields([{
      label: _i18n.i18n.translate('xpack.observability.threshold.rule.alertDetailsAppSection.summaryField.rule', {
        defaultMessage: 'Rule'
      }),
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "alertDetailsAppSectionRuleLink",
        href: ruleLink
      }, rule.name)
    }]);
  }, [alert, rule, ruleLink, setAlertSummaryFields]);
  return !!rule.params.criteria ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "metricThresholdAppSection"
  }, rule.params.criteria.map((criterion, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: (0, _generate_unique_key.generateUniqueKey)(criterion)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, criterion.aggType.toUpperCase(), ' ', 'metric' in criterion ? criterion.metric : undefined)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.threshold.rule.alertDetailsAppSection.criterion.subtitle",
    defaultMessage: "Last {lookback} {timeLabel}",
    values: {
      lookback: criterion.timeSize,
      timeLabel: _criterion_preview_chart.TIME_LABELS[criterion.timeUnit]
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minHeight: 150,
      minWidth: 160
    },
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
    chartProps: chartProps,
    id: `threshold-${(0, _generate_unique_key.generateUniqueKey)(criterion)}`,
    threshold: criterion.threshold[0],
    value: alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUES][index],
    valueFormatter: d => (0, _metric_value_formatter.metricValueFormatter)(d, 'metric' in criterion ? criterion.metric : undefined),
    title: _i18n.i18n.translate('xpack.observability.threshold.rule.alertDetailsAppSection.thresholdTitle', {
      defaultMessage: 'Threshold breached'
    }),
    comparator: criterion.comparator
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_expression_chart.ExpressionChart, {
    annotations: annotations,
    chartType: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    derivedIndexPattern: derivedIndexPattern,
    expression: criterion,
    filterQuery: rule.params.filterQueryText,
    groupBy: rule.params.groupBy,
    hideTitle: true,
    timeRange: timeRange
  }))))))) : null;
}
module.exports = exports.default;