"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoPilotPromptFeedback = CoPilotPromptFeedback;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CoPilotPromptFeedback({
  coPilot,
  promptId,
  messages,
  response,
  responseTime
}) {
  const theme = (0, _eui.useEuiTheme)();
  const [hasSubmittedFeedback, setHasSubmittedFeedback] = (0, _react.useState)(false);
  const submitFeedback = (0, _react.useCallback)(positive => {
    setHasSubmittedFeedback(true);
    if (messages) {
      coPilot.track({
        messages,
        response,
        responseTime,
        promptId,
        feedbackAction: positive ? 'thumbsup' : 'thumbsdown'
      }).catch(err => {});
    }
  }, [coPilot, promptId, messages, response, responseTime]);
  const [hasSubmittedTelemetry, setHasSubmittedTelemetry] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!hasSubmittedTelemetry && messages) {
      setHasSubmittedTelemetry(true);
      coPilot.track({
        messages,
        response,
        responseTime,
        promptId
      }).catch(err => {});
    }
  }, [coPilot, promptId, messages, response, responseTime, hasSubmittedTelemetry]);
  if (hasSubmittedFeedback) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: theme.euiTheme.colors.primaryText
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: theme.euiTheme.colors.primaryText
    }, _i18n.i18n.translate('xpack.observability.coPilotPrompt.feedbackSubmittedText', {
      defaultMessage: "Thank you for submitting your feedback! We'll use this to improve responses."
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: theme.euiTheme.colors.primaryText
  }, _i18n.i18n.translate('xpack.observability.coPilotPrompt.feedbackActionTitle', {
    defaultMessage: 'Did you find this response helpful?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "CoPilotPromptButtonHappy",
    iconType: "faceHappy",
    onClick: () => {
      submitFeedback(true);
    }
  }, _i18n.i18n.translate('xpack.observability.coPilotPrompt.likedFeedbackButtonTitle', {
    defaultMessage: 'Yes'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "CoPilotPromptButtonSad",
    iconType: "faceSad",
    onClick: () => {
      submitFeedback(false);
    }
  }, _i18n.i18n.translate('xpack.observability.coPilotPrompt.dislikedFeedbackButtonTitle', {
    defaultMessage: 'No'
  }))));
}