"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyoutFooter = AlertsFlyoutFooter;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _is_alert_details_enabled = require("../../utils/is_alert_details_enabled");
var _translations = require("../../config/translations");
var _paths = require("../../config/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyoutFooter({
  alert,
  isInApp
}) {
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const getAlertDetailsButton = () => {
    if (!(0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alert, config)) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: prepend && prepend(_paths.paths.observability.alertDetails(alert.fields['kibana.alert.uuid'])),
      "data-test-subj": "alertsFlyoutAlertDetailsButton",
      fill: true
    }, _translations.translations.alertsFlyout.alertDetailsButtonText));
  };
  const getViewInAppUrlButton = () => {
    if (!alert.link || isInApp) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: prepend && prepend(alert.link),
      "data-test-subj": "alertsFlyoutViewInAppButton",
      fill: true
    }, _translations.translations.alertsFlyout.viewInAppButtonText));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, getViewInAppUrlButton(), getAlertDetailsButton()));
}