"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.elasticAgentRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _get_authentication_api_key = require("../../lib/get_authentication_api_key");
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _get_observability_onboarding_state = require("../custom_logs/get_observability_onboarding_state");
var _generate_yml = require("./generate_yml");
var _get_fallback_urls = require("../custom_logs/get_fallback_urls");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConfig = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/elastic_agent/config',
  params: t.type({
    query: t.type({
      onboardingId: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    var _plugins$cloud$setup$, _plugins$cloud, _plugins$cloud$setup;
    const {
      params: {
        query: {
          onboardingId
        }
      },
      core,
      plugins,
      request
    } = resources;
    const authApiKey = (0, _get_authentication_api_key.getAuthenticationAPIKey)(request);
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.createInternalRepository();
    const elasticsearchUrl = (_plugins$cloud$setup$ = (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : (_plugins$cloud$setup = _plugins$cloud.setup) === null || _plugins$cloud$setup === void 0 ? void 0 : _plugins$cloud$setup.elasticsearchUrl) !== null && _plugins$cloud$setup$ !== void 0 ? _plugins$cloud$setup$ : (0, _get_fallback_urls.getFallbackUrls)(coreStart).elasticsearchUrl;
    const savedState = await (0, _get_observability_onboarding_state.getObservabilityOnboardingState)({
      savedObjectsClient,
      savedObjectId: onboardingId
    });
    const yaml = (0, _generate_yml.generateYml)({
      datasetName: savedState === null || savedState === void 0 ? void 0 : savedState.state.datasetName,
      customConfigurations: savedState === null || savedState === void 0 ? void 0 : savedState.state.customConfigurations,
      logFilePaths: savedState === null || savedState === void 0 ? void 0 : savedState.state.logFilePaths,
      namespace: savedState === null || savedState === void 0 ? void 0 : savedState.state.namespace,
      apiKey: authApiKey ? `${authApiKey === null || authApiKey === void 0 ? void 0 : authApiKey.apiKeyId}:${authApiKey === null || authApiKey === void 0 ? void 0 : authApiKey.apiKey}` : '$API_KEY',
      esHost: [elasticsearchUrl],
      logfileId: `custom-logs-${Date.now()}`,
      serviceName: savedState === null || savedState === void 0 ? void 0 : savedState.state.serviceName
    });
    return yaml;
  }
});
const elasticAgentRouteRepository = {
  ...generateConfig
};
exports.elasticAgentRouteRepository = elasticAgentRouteRepository;