"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customLogsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_observability_onboarding_server_route = require("../create_observability_onboarding_server_route");
var _create_shipper_api_key = require("./api_key/create_shipper_api_key");
var _has_log_monitoring_privileges = require("./api_key/has_log_monitoring_privileges");
var _get_fallback_urls = require("./get_fallback_urls");
var _get_has_logs = require("./get_has_logs");
var _get_observability_onboarding_state = require("./get_observability_onboarding_state");
var _save_observability_onboarding_state = require("./save_observability_onboarding_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ELASTIC_AGENT_VERSION = '8.8.0'; // This should be defined from a source with the latest public release

const logMonitoringPrivilegesRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/custom_logs/privileges',
  options: {
    tags: []
  },
  handler: async resources => {
    const {
      context
    } = resources;
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const hasPrivileges = await (0, _has_log_monitoring_privileges.hasLogMonitoringPrivileges)(client.asCurrentUser);
    return {
      hasPrivileges
    };
  }
});
const installShipperSetupRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/custom_logs/install_shipper_setup',
  options: {
    tags: []
  },
  async handler(resources) {
    var _ref, _core$setup$http$base, _plugins$cloud, _plugins$cloud$setup;
    const {
      core,
      plugins
    } = resources;
    const coreStart = await core.start();
    const kibanaUrl = (_ref = (_core$setup$http$base = core.setup.http.basePath.publicBaseUrl) !== null && _core$setup$http$base !== void 0 ? _core$setup$http$base : // priority given to server.publicBaseUrl
    (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : (_plugins$cloud$setup = _plugins$cloud.setup) === null || _plugins$cloud$setup === void 0 ? void 0 : _plugins$cloud$setup.kibanaUrl) !== null && _ref !== void 0 ? _ref :
    // then cloud id
    (0, _get_fallback_urls.getFallbackUrls)(coreStart).kibanaUrl; // falls back to local network binding
    const scriptDownloadUrl = `${kibanaUrl}/plugins/observabilityOnboarding/assets/standalone_agent_setup.sh`;
    const apiEndpoint = `${kibanaUrl}/internal/observability_onboarding`;
    return {
      apiEndpoint,
      scriptDownloadUrl,
      elasticAgentVersion: ELASTIC_AGENT_VERSION
    };
  }
});
const createApiKeyRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/custom_logs/save',
  options: {
    tags: []
  },
  params: t.type({
    body: t.type({
      name: t.string,
      state: t.record(t.string, t.unknown)
    })
  }),
  async handler(resources) {
    const {
      context,
      params: {
        body: {
          name,
          state
        }
      },
      core,
      request
    } = resources;
    const coreStart = await core.start();
    const {
      elasticsearch: {
        client
      }
    } = await context.core;
    const {
      encoded: apiKeyEncoded
    } = await (0, _create_shipper_api_key.createShipperApiKey)(client.asCurrentUser, name);
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const {
      id
    } = await (0, _save_observability_onboarding_state.saveObservabilityOnboardingState)({
      savedObjectsClient,
      observabilityOnboardingState: {
        state
      }
    });
    return {
      apiKeyEncoded,
      onboardingId: id
    };
  }
});
const updateOnboardingStateRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'PUT /internal/observability_onboarding/custom_logs/{onboardingId}/save',
  options: {
    tags: []
  },
  params: t.type({
    path: t.type({
      onboardingId: t.string
    }),
    body: t.type({
      state: t.record(t.string, t.unknown)
    })
  }),
  async handler(resources) {
    const {
      params: {
        path: {
          onboardingId
        },
        body: {
          state
        }
      },
      core,
      request
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const {
      id
    } = await (0, _save_observability_onboarding_state.saveObservabilityOnboardingState)({
      savedObjectsClient,
      savedObjectId: onboardingId,
      observabilityOnboardingState: {
        state
      }
    });
    return {
      onboardingId: id
    };
  }
});
const stepProgressUpdateRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'POST /internal/observability_onboarding/custom_logs/{id}/step/{name}',
  options: {
    tags: []
  },
  params: t.type({
    path: t.type({
      id: t.string,
      name: t.string
    }),
    body: t.type({
      status: t.string
    })
  }),
  async handler(resources) {
    const {
      params: {
        path: {
          id,
          name
        },
        body: {
          status
        }
      },
      core
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.createInternalRepository();
    const savedObservabilityOnboardingState = await (0, _get_observability_onboarding_state.getObservabilityOnboardingState)({
      savedObjectsClient,
      savedObjectId: id
    });
    if (!savedObservabilityOnboardingState) {
      return {
        message: 'Unable to report setup progress - onboarding session not found.'
      };
    }
    const {
      id: savedObjectId,
      updatedAt,
      ...observabilityOnboardingState
    } = savedObservabilityOnboardingState;
    await (0, _save_observability_onboarding_state.saveObservabilityOnboardingState)({
      savedObjectsClient,
      savedObjectId,
      observabilityOnboardingState: {
        ...observabilityOnboardingState,
        progress: {
          ...observabilityOnboardingState.progress,
          [name]: status
        }
      }
    });
    return {
      name,
      status
    };
  }
});
const getProgressRoute = (0, _create_observability_onboarding_server_route.createObservabilityOnboardingServerRoute)({
  endpoint: 'GET /internal/observability_onboarding/custom_logs/{onboardingId}/progress',
  options: {
    tags: []
  },
  params: t.type({
    path: t.type({
      onboardingId: t.string
    })
  }),
  async handler(resources) {
    const {
      params: {
        path: {
          onboardingId
        }
      },
      core,
      request
    } = resources;
    const coreStart = await core.start();
    const savedObjectsClient = coreStart.savedObjects.createInternalRepository();
    const savedObservabilityOnboardingState = (await (0, _get_observability_onboarding_state.getObservabilityOnboardingState)({
      savedObjectsClient,
      savedObjectId: onboardingId
    })) || null;
    const progress = {
      ...(savedObservabilityOnboardingState === null || savedObservabilityOnboardingState === void 0 ? void 0 : savedObservabilityOnboardingState.progress)
    };
    const esClient = coreStart.elasticsearch.client.asScoped(request).asCurrentUser;
    if (savedObservabilityOnboardingState) {
      const {
        state: {
          datasetName: dataset,
          namespace
        }
      } = savedObservabilityOnboardingState;
      if (progress['ea-status'] === 'complete') {
        try {
          const hasLogs = await (0, _get_has_logs.getHasLogs)({
            dataset,
            namespace,
            esClient
          });
          if (hasLogs) {
            progress['logs-ingest'] = 'complete';
          } else {
            progress['logs-ingest'] = 'loading';
          }
        } catch (error) {
          progress['logs-ingest'] = 'warning';
        }
      } else {
        progress['logs-ingest'] = 'incomplete';
      }
    }
    return {
      progress
    };
  }
});
const customLogsRouteRepository = {
  ...logMonitoringPrivilegesRoute,
  ...installShipperSetupRoute,
  ...createApiKeyRoute,
  ...updateOnboardingStateRoute,
  ...stepProgressUpdateRoute,
  ...getProgressRoute
};
exports.customLogsRouteRepository = customLogsRouteRepository;