"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Home = Home;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _use_kibana_navigation = require("../../../hooks/use_kibana_navigation");
var _app = require("../../../application/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Home() {
  (0, _public.useBreadcrumbs)([], _app.breadcrumbsApp);
  const {
    navigateToKibanaUrl
  } = (0, _use_kibana_navigation.useKibanaNavigation)();
  const handleClickSystemLogs = () => {};
  const handleClickCustomLogs = () => {
    navigateToKibanaUrl('/app/observabilityOnboarding/customLogs');
  };
  const handleClickApmSetupGuide = () => {
    navigateToKibanaUrl('/app/home#/tutorial/apm');
  };
  const handleClickKubernetesSetupGuide = () => {
    navigateToKibanaUrl('/app/integrations/detail/kubernetes');
  };
  const handleClickIntegrations = () => {
    navigateToKibanaUrl('/app/integrations');
  };
  const handleClickSampleData = () => {
    navigateToKibanaUrl('/app/home#/tutorial_directory/sampleData');
  };
  const handleClickSkip = () => {
    navigateToKibanaUrl('/app/observability/overview');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    style: {
      margin: 'auto',
      maxWidth: 800
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "obltOnboardingHomeTitle"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.observability_onboarding.home.title', {
    defaultMessage: 'Get started with Observability'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.home.description', {
    defaultMessage: 'Monitor and gain insights across your cloud-native and distributed systems on a single platform.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "bolt"
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.quickstartBadge', {
      defaultMessage: 'Quickstart'
    })),
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.title', {
      defaultMessage: 'Collect system logs'
    }),
    selectable: {
      onClick: handleClickSystemLogs,
      color: 'primary',
      fill: true,
      fullWidth: false,
      style: {
        margin: 'auto'
      }
    },
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    style: {
      marginLeft: 'auto',
      marginRight: 'auto',
      width: '80%'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "left"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.description1', {
    defaultMessage: 'The quickest path to onboard log data and start analysing it straight away.'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.systemLogs.description2', {
    defaultMessage: 'Monitor servers, personal computers and more by collecting logs from your machine.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "launch"
    }, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.fewMinutesBadge', {
      defaultMessage: 'In a few minutes'
    })),
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.title', {
      defaultMessage: 'Collect custom logs'
    }),
    selectable: {
      onClick: handleClickCustomLogs,
      color: 'primary',
      fill: true,
      fullWidth: false,
      style: {
        margin: 'auto'
      }
    },
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    style: {
      marginLeft: 'auto',
      marginRight: 'auto',
      width: '80%'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "left"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.description.text', {
    defaultMessage: 'Choose what logs to collect, configure an ingest pipeline, and explore your data.'
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.description.example.streamlogs', {
    defaultMessage: 'Stream custom logs'
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.description.example.networkStream', {
    defaultMessage: 'Collect network streaming logs'
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.description.example.uploadLogFile', {
    defaultMessage: 'Upload log files'
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.observability_onboarding.card.customLogs.description.example.andMore', {
    defaultMessage: '... and more'
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    betaBadgeProps: {
      label: setupGuideBadgeLabel
    },
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.apm.title', {
      defaultMessage: 'Monitor my application performance (APM / tracing)'
    }),
    titleSize: "xs",
    paddingSize: "xl",
    onClick: handleClickApmSetupGuide
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    betaBadgeProps: {
      label: setupGuideBadgeLabel
    },
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.k8s.title', {
      defaultMessage: 'Monitor my kubernetes clusters'
    }),
    titleSize: "xs",
    paddingSize: "xl",
    onClick: handleClickKubernetesSetupGuide
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    betaBadgeProps: {
      label: _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.badgeLabel', {
        defaultMessage: 'Integrations'
      })
    },
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.integrations.title', {
      defaultMessage: 'Explore 300+ ways of ingesting data with our Integrations'
    }),
    titleSize: "xs",
    paddingSize: "xl",
    onClick: handleClickIntegrations
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    betaBadgeProps: {
      label: _i18n.i18n.translate('xpack.observability_onboarding.card.sampleData.badgeLabel', {
        defaultMessage: 'Sample data'
      })
    },
    title: _i18n.i18n.translate('xpack.observability_onboarding.card.sampleData.title', {
      defaultMessage: 'Explore data, visualizations, and dashboards samples'
    }),
    titleSize: "xs",
    paddingSize: "xl",
    onClick: handleClickSampleData
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleClickSkip,
    "data-test-subj": "obltOnboardingHomeSkipButton"
  }, _i18n.i18n.translate('xpack.observability_onboarding.skipLinkLabel', {
    defaultMessage: 'Skip for now'
  }))));
}
const setupGuideBadgeLabel = _i18n.i18n.translate('xpack.observability_onboarding.card.setupGuide', {
  defaultMessage: 'Setup guide'
});