"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgent = InstallElasticAgent;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _buffer = require("buffer");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _ = require(".");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_kibana_navigation = require("../../../../hooks/use_kibana_navigation");
var _step_panel = require("../../../shared/step_panel");
var _api_key_banner = require("./api_key_banner");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InstallElasticAgent() {
  const {
    navigateToKibanaUrl
  } = (0, _use_kibana_navigation.useKibanaNavigation)();
  const {
    goBack,
    goToStep,
    getState,
    setState,
    CurrentStep
  } = (0, _.useWizard)();
  const wizardState = getState();
  const [elasticAgentPlatform, setElasticAgentPlatform] = (0, _react2.useState)('linux-tar');
  function onInspect() {
    goToStep('inspect');
  }
  function onContinue() {
    navigateToKibanaUrl('/app/logs/stream');
  }
  function onBack() {
    goBack();
  }
  function onAutoDownloadConfig() {
    setState(state => ({
      ...state,
      autoDownloadConfig: !state.autoDownloadConfig
    }));
  }
  const {
    data: monitoringRole,
    status: monitoringRoleStatus
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (CurrentStep === InstallElasticAgent && !hasAlreadySavedFlow(getState())) {
      return callApi('GET /internal/observability_onboarding/custom_logs/privileges');
    }
  }, []);
  const {
    data: setup
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (CurrentStep === InstallElasticAgent) {
      return callApi('GET /internal/observability_onboarding/custom_logs/install_shipper_setup');
    }
  }, []);
  const {
    data: installShipperSetup,
    status: installShipperSetupStatus,
    error
  } = (0, _use_fetcher.useFetcher)(callApi => {
    const {
      datasetName,
      serviceName,
      namespace,
      customConfigurations,
      logFilePaths
    } = getState();
    if (CurrentStep === InstallElasticAgent && !hasAlreadySavedFlow(getState()) && monitoringRole !== null && monitoringRole !== void 0 && monitoringRole.hasPrivileges) {
      return callApi('POST /internal/observability_onboarding/custom_logs/save', {
        params: {
          body: {
            name: datasetName,
            state: {
              datasetName,
              serviceName,
              namespace,
              customConfigurations,
              logFilePaths
            }
          }
        }
      });
    }
  }, [monitoringRole === null || monitoringRole === void 0 ? void 0 : monitoringRole.hasPrivileges]);
  const {
    status: saveOnboardingStateDataStatus
  } = (0, _use_fetcher.useFetcher)(callApi => {
    const {
      onboardingId,
      datasetName,
      serviceName,
      namespace,
      customConfigurations,
      logFilePaths
    } = getState();
    if (CurrentStep === InstallElasticAgent && onboardingId) {
      return callApi('PUT /internal/observability_onboarding/custom_logs/{onboardingId}/save', {
        params: {
          path: {
            onboardingId
          },
          body: {
            state: {
              datasetName,
              serviceName,
              namespace,
              customConfigurations,
              logFilePaths
            }
          }
        }
      });
    }
  }, []);
  const {
    apiKeyEncoded,
    onboardingId
  } = installShipperSetup !== null && installShipperSetup !== void 0 ? installShipperSetup : getState();
  const {
    data: yamlConfig = '',
    status: yamlConfigStatus
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (CurrentStep === InstallElasticAgent && apiKeyEncoded && onboardingId) {
      return callApi('GET /internal/observability_onboarding/elastic_agent/config', {
        headers: {
          authorization: `ApiKey ${apiKeyEncoded}`
        },
        params: {
          query: {
            onboardingId
          }
        }
      });
    }
  }, [apiKeyEncoded, onboardingId, saveOnboardingStateDataStatus === _use_fetcher.FETCH_STATUS.SUCCESS]);
  (0, _react2.useEffect)(() => {
    setState(state => ({
      ...state,
      onboardingId,
      apiKeyEncoded
    }));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onboardingId, apiKeyEncoded]);
  const {
    data: progressData,
    status: progressStatus,
    refetch: refetchProgress
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (CurrentStep === InstallElasticAgent && onboardingId) {
      return callApi('GET /internal/observability_onboarding/custom_logs/{onboardingId}/progress', {
        params: {
          path: {
            onboardingId
          }
        }
      });
    }
  }, [onboardingId]);
  const progressSucceded = progressStatus === _use_fetcher.FETCH_STATUS.SUCCESS;
  (0, _react2.useEffect)(() => {
    if (progressSucceded) {
      setTimeout(() => {
        refetchProgress();
      }, 2000);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [progressSucceded]);
  const getStep = (0, _react2.useCallback)(({
    id,
    incompleteTitle,
    loadingTitle,
    completedTitle
  }) => {
    const progress = progressData === null || progressData === void 0 ? void 0 : progressData.progress;
    if (progress) {
      const stepStatus = progress[id];
      const title = stepStatus === 'loading' ? loadingTitle : stepStatus === 'complete' ? completedTitle : incompleteTitle;
      return {
        title,
        children: null,
        status: stepStatus !== null && stepStatus !== void 0 ? stepStatus : 'incomplete'
      };
    }
    return {
      title: incompleteTitle,
      children: null,
      status: 'incomplete'
    };
  }, [progressData === null || progressData === void 0 ? void 0 : progressData.progress]);
  const isInstallStarted = (progressData === null || progressData === void 0 ? void 0 : progressData.progress['ea-download']) !== undefined;
  const isInstallCompleted = (progressData === null || progressData === void 0 ? void 0 : progressData.progress['ea-status']) === 'complete';
  const autoDownloadConfigStep = getStep({
    id: 'ea-config',
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.incompleteTitle', {
      defaultMessage: 'Configure the agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.loadingTitle', {
      defaultMessage: 'Downloading Elastic Agent config'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.completedTitle', {
      defaultMessage: 'Elastic Agent config written to {configPath}',
      values: {
        configPath: '/opt/Elastic/Agent/elastic-agent.yml'
      }
    })
  });
  return /*#__PURE__*/_react2.default.createElement(_step_panel.StepPanel, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.title', {
      defaultMessage: 'Install shipper to collect data'
    }),
    panelFooter: /*#__PURE__*/_react2.default.createElement(_step_panel.StepPanelFooter, {
      items: [/*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
        color: "text",
        onClick: onBack
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.back', {
        defaultMessage: 'Back'
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd",
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
        onClick: onInspect
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.inspect', {
        defaultMessage: 'Inspect'
      }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
        color: "success",
        fill: true,
        iconType: "magnifyWithPlus",
        onClick: onContinue
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.exploreLogs', {
        defaultMessage: 'Explore logs'
      }))))]
    })
  }, /*#__PURE__*/_react2.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react2.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.description', {
    defaultMessage: 'Add Elastic Agent to your hosts to begin sending data to your Elastic Cloud. Run standalone if you want to download and manage each agent configuration file on your own, or enroll in Fleet, for centralized management of all your agents through our Fleet managed interface.'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), apiKeyEncoded && onboardingId ? /*#__PURE__*/_react2.default.createElement(_api_key_banner.ApiKeyBanner, {
    payload: {
      apiKeyEncoded,
      onboardingId
    },
    hasPrivileges: true,
    status: _use_fetcher.FETCH_STATUS.SUCCESS
  }) : monitoringRoleStatus !== _use_fetcher.FETCH_STATUS.NOT_INITIATED && monitoringRoleStatus !== _use_fetcher.FETCH_STATUS.LOADING && /*#__PURE__*/_react2.default.createElement(_api_key_banner.ApiKeyBanner, {
    payload: installShipperSetup,
    hasPrivileges: monitoringRole === null || monitoringRole === void 0 ? void 0 : monitoringRole.hasPrivileges,
    status: installShipperSetupStatus,
    error: error
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.title', {
        defaultMessage: 'Install the Elastic Agent'
      }),
      status: installShipperSetupStatus === _use_fetcher.FETCH_STATUS.LOADING ? 'loading' : isInstallCompleted ? 'complete' : 'current',
      children: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react2.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.description', {
        defaultMessage: 'Select a platform and run the command to install in your Terminal, enroll, and start the Elastic Agent. Do this for each host. For other platforms, see our downloads page.  Review host requirements and other installation options.'
      }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
        isFullWidth: true,
        legend: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform', {
          defaultMessage: 'Choose platform'
        }),
        options: [{
          id: 'linux-tar',
          label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform.linux', {
            defaultMessage: 'Linux'
          })
        }, {
          id: 'macos',
          label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform.macOS', {
            defaultMessage: 'MacOS'
          }),
          isDisabled: true
        }, {
          id: 'windows',
          label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform.windows', {
            defaultMessage: 'Windows'
          }),
          isDisabled: true
        }],
        type: "single",
        idSelected: elasticAgentPlatform,
        onChange: id => setElasticAgentPlatform(id)
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
        language: "bash",
        isCopyable: true
      }, getInstallShipperCommand({
        elasticAgentPlatform,
        apiKeyEncoded,
        apiEndpoint: setup === null || setup === void 0 ? void 0 : setup.apiEndpoint,
        scriptDownloadUrl: setup === null || setup === void 0 ? void 0 : setup.scriptDownloadUrl,
        elasticAgentVersion: setup === null || setup === void 0 ? void 0 : setup.elasticAgentVersion,
        autoDownloadConfig: wizardState.autoDownloadConfig,
        onboardingId
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
        label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig', {
          defaultMessage: 'Auto download config'
        }),
        checked: wizardState.autoDownloadConfig,
        onChange: onAutoDownloadConfig,
        disabled: isInstallStarted || monitoringRole && !(monitoringRole !== null && monitoringRole !== void 0 && monitoringRole.hasPrivileges)
      }), isInstallStarted && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSubSteps, null, [{
        id: 'ea-download',
        incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.incompleteTitle', {
          defaultMessage: 'Download Elastic Agent'
        }),
        loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.loadingTitle', {
          defaultMessage: 'Downloading Elastic Agent'
        }),
        completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.completedTitle', {
          defaultMessage: 'Elastic Agent downloaded'
        })
      }, {
        id: 'ea-extract',
        incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.incompleteTitle', {
          defaultMessage: 'Extract Elastic Agent'
        }),
        loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.loadingTitle', {
          defaultMessage: 'Extracting Elastic Agent'
        }),
        completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.completedTitle', {
          defaultMessage: 'Elastic Agent extracted'
        })
      }, {
        id: 'ea-install',
        incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.incompleteTitle', {
          defaultMessage: 'Install Elastic Agent'
        }),
        loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.loadingTitle', {
          defaultMessage: 'Installing Elastic Agent'
        }),
        completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.completedTitle', {
          defaultMessage: 'Elastic Agent installed'
        })
      }, {
        id: 'ea-status',
        incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.incompleteTitle', {
          defaultMessage: 'Connect to the Elastic Agent'
        }),
        loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.loadingTitle', {
          defaultMessage: 'Connecting to the Elastic Agent'
        }),
        completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.completedTitle', {
          defaultMessage: 'Connected to the Elastic Agent'
        })
      }].map((step, index) => {
        const {
          title,
          status
        } = getStep(step);
        return /*#__PURE__*/_react2.default.createElement(_eui.EuiStep, {
          key: step.id,
          titleSize: "xs",
          step: index + 1,
          title: title,
          status: status,
          children: null,
          css: (0, _react.css)({
            '> .euiStep__content': {
              paddingBottom: 0
            }
          })
        });
      }))))
    }, {
      title: wizardState.autoDownloadConfig ? autoDownloadConfigStep.title : _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.incompleteTitle', {
        defaultMessage: 'Configure the agent'
      }),
      status: yamlConfigStatus === _use_fetcher.FETCH_STATUS.LOADING ? 'loading' : autoDownloadConfigStep.status,
      children: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react2.default.createElement("p", null, wizardState.autoDownloadConfig ? _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.auto.description', {
        defaultMessage: 'The agent config below will be downloaded by the install script and written to ({configPath}). This will overwrite any existing agent configuration.',
        values: {
          configPath: '/opt/Elastic/Agent/elastic-agent.yml'
        }
      }) : _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.manual.description', {
        defaultMessage: 'Copy the config below to the elastic agent.yml on the host where the Elastic Agent is installed ({configPath}).',
        values: {
          configPath: '/opt/Elastic/Agent/elastic-agent.yml'
        }
      }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonRectangle, {
        isLoading: yamlConfigStatus === _use_fetcher.FETCH_STATUS.NOT_INITIATED,
        contentAriaLabel: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.yamlCodeBlockdescription', {
          defaultMessage: 'Elastic agent yaml configuration'
        }),
        width: "100%",
        height: 300,
        borderRadius: "s"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
        language: "yaml",
        isCopyable: true,
        style: {
          opacity: wizardState.autoDownloadConfig ? '.5' : '1'
        }
      }, yamlConfig)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
        iconType: "download",
        color: "primary",
        href: `data:application/yaml;base64,${_buffer.Buffer.from(yamlConfig, 'utf8').toString('base64')}`,
        download: "elastic-agent.yml",
        target: "_blank",
        isDisabled: wizardState.autoDownloadConfig
      }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.downloadConfigButton', {
        defaultMessage: 'Download config file'
      })))
    }, getStep({
      id: 'logs-ingest',
      incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.logsIngest.incompleteTitle', {
        defaultMessage: 'Check for shipped logs'
      }),
      loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.logsIngest.loadingTitle', {
        defaultMessage: 'Waiting for logs to be shipped'
      }),
      completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.logsIngest.completedTitle', {
        defaultMessage: 'Logs are being shipped!'
      })
    })]
  })));
}
function getInstallShipperCommand({
  elasticAgentPlatform,
  apiKeyEncoded = '$API_KEY',
  apiEndpoint = '$API_ENDPOINT',
  scriptDownloadUrl = '$SCRIPT_DOWNLOAD_URL',
  elasticAgentVersion = '$ELASTIC_AGENT_VERSION',
  autoDownloadConfig = false,
  onboardingId = '$ONBOARDING_ID'
}) {
  const setupScriptFilename = 'standalone_agent_setup.sh';
  const PLATFORM_COMMAND = {
    'linux-tar': oneLine`
      curl ${scriptDownloadUrl} -o ${setupScriptFilename} &&
      sudo bash ${setupScriptFilename} ${apiKeyEncoded} ${apiEndpoint} ${elasticAgentVersion} ${onboardingId} ${autoDownloadConfig ? 'autoDownloadConfig=1' : ''}
    `,
    macos: oneLine`
      curl -O https://elastic.co/agent-setup.sh &&
      sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==
    `,
    windows: oneLine`
      curl -O https://elastic.co/agent-setup.sh &&
      sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==
    `
  };
  return PLATFORM_COMMAND[elasticAgentPlatform];
}
function oneLine(parts, ...args) {
  const str = (0, _lodash.flatten)((0, _lodash.zip)(parts, args)).join('');
  return str.replace(/\s+/g, ' ').trim();
}
function hasAlreadySavedFlow({
  apiKeyEncoded,
  onboardingId
}) {
  return Boolean(apiKeyEncoded && onboardingId);
}