"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HorizontalSteps = HorizontalSteps;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HorizontalSteps() {
  const {
    getPath,
    goToStep
  } = (0, _.useWizard)();
  const [currentStep, ...previousSteps] = getPath().reverse();
  function getStatus(stepKey) {
    if (currentStep === stepKey) {
      return 'current';
    }
    if (previousSteps.includes(stepKey)) {
      return 'complete';
    }
    return 'incomplete';
  }
  function isDisabled(stepKey) {
    return getStatus(stepKey) === 'incomplete';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.steps.selectLogs', {
        defaultMessage: 'Select logs'
      }),
      status: getStatus('selectLogs'),
      onClick: () => {
        goToStep('selectLogs');
      }
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.steps.configureLogs', {
        defaultMessage: 'Configure logs'
      }),
      status: getStatus('configureLogs'),
      disabled: isDisabled('configureLogs'),
      onClick: () => {
        goToStep('configureLogs');
      }
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.steps.installShipper', {
        defaultMessage: 'Install shipper'
      }),
      status: getStatus('installElasticAgent'),
      disabled: isDisabled('installElasticAgent'),
      onClick: () => {
        goToStep('installElasticAgent');
      }
    }]
  });
}