"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureLogs = ConfigureLogs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _2 = require(".");
var _optional_form_row = require("../../../shared/optional_form_row");
var _step_panel = require("../../../shared/step_panel");
var _get_filename = require("./get_filename");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfigureLogs() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const {
    goToStep,
    goBack,
    getState,
    setState
  } = (0, _2.useWizard)();
  const wizardState = getState();
  const [datasetName, setDatasetName] = (0, _react.useState)(wizardState.datasetName);
  const [serviceName, setServiceName] = (0, _react.useState)(wizardState.serviceName);
  const [logFilePaths, setLogFilePaths] = (0, _react.useState)(wizardState.logFilePaths);
  const [namespace, setNamespace] = (0, _react.useState)(wizardState.namespace);
  const [customConfigurations, setCustomConfigurations] = (0, _react.useState)(wizardState.customConfigurations);
  const logFilePathNotConfigured = logFilePaths.every(filepath => !filepath);
  function onBack() {
    goBack();
  }
  function onContinue() {
    setState(state => ({
      ...state,
      datasetName,
      serviceName,
      logFilePaths: logFilePaths.filter(filepath => !!filepath),
      namespace,
      customConfigurations
    }));
    goToStep('installElasticAgent');
  }
  function addLogFilePath() {
    setLogFilePaths(prev => [...prev, '']);
  }
  function removeLogFilePath(index) {
    setLogFilePaths(prev => prev.filter((_, i) => i !== index));
  }
  function onLogFilePathChanges(index, event) {
    var _event$currentTarget;
    const filepath = (_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 ? void 0 : _event$currentTarget.value;
    setLogFilePaths(prev => prev.map((path, i) => i === index ? filepath : path));
    if (index === 0) {
      setDatasetName((0, _get_filename.getFilename)(filepath));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.title', {
      defaultMessage: 'Stream log files to Elastic'
    }),
    panelFooter: /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "text",
        onClick: onBack
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.back', {
        defaultMessage: 'Back'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        onClick: onContinue,
        isDisabled: logFilePathNotConfigured || !datasetName || !namespace
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.continue', {
        defaultMessage: 'Continue'
      }))]
    })
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.description', {
    defaultMessage: 'Fill the paths to the log files on your hosts.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.path', {
      defaultMessage: 'Log file path'
    }),
    helpText: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.helper', {
      defaultMessage: 'You can use a log file path or a log pattern.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, logFilePaths.map((filepath, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.placeholder', {
      defaultMessage: 'Example: /var/log/application.*'
    }),
    value: filepath,
    onChange: ev => onLogFilePathChanges(index, ev)
  })), index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    "aria-label": "Delete",
    onClick: () => removeLogFilePath(index)
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: addLogFilePath
  }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.addRow', {
    defaultMessage: 'Add row'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.dataset.name', {
      defaultMessage: 'Dataset name'
    }),
    helpText: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.dataset.helper', {
      defaultMessage: "Pick a name for your logs. All lowercase, max 100 chars, special characters will be replaced with '_'."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.dataset.placeholder', {
      defaultMessage: 'Dataset name'
    }),
    value: datasetName,
    onChange: event => setDatasetName((0, _get_filename.replaceSpecialChars)(event.target.value))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_optional_form_row.OptionalFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.serviceName', {
      defaultMessage: 'Service name'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.configureLogs.serviceName.helper",
      defaultMessage: "Name the service your data is collected from."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.serviceName.placeholder', {
      defaultMessage: 'Give a name to your service'
    }),
    value: serviceName,
    onChange: event => setServiceName(event.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedSettingsAccordion",
    css: {
      '.euiAccordion__buttonContent': {
        color: euiTheme.colors.primaryText,
        fontSize: xsFontSize
      },
      '.euiAccordion__iconButton svg': {
        stroke: euiTheme.colors.primary,
        width: euiTheme.size.m,
        height: euiTheme.size.m
      }
    },
    buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.advancedSettings', {
      defaultMessage: 'Advanced settings'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.namespace', {
      defaultMessage: 'Namespace'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.configureLogs.namespace.helper",
      defaultMessage: "This setting changes the name of the integration's data stream. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          target: "_blank",
          href: 'https://www.elastic.co/guide/en/fleet/current/data-streams.html#data-streams-naming-scheme'
        }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.learnMore', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.namespace.placeholder', {
      defaultMessage: 'Namespace'
    }),
    value: namespace,
    onChange: event => setNamespace(event.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_optional_form_row.OptionalFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.customConfig', {
      defaultMessage: 'Custom configurations'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.configureLogs.customConfig.helper",
      defaultMessage: "Here YAML configuration options can be used to be added to your configuration. Be careful using this as it might break your configuration file. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          target: "_blank",
          href: 'https://www.elastic.co/guide/en/observability/current/ingest-logs-metrics-uptime.html'
        }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.learnMore', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    value: customConfigurations,
    onChange: event => setCustomConfigurations(event.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
}