"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMonitoringTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("../setup_mode/formatting");
var _setup_mode = require("../../lib/setup_mode");
var _enums = require("../../../common/enums");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiMonitoringTable = ({
  rows: items,
  search = {},
  columns: _columns,
  setupMode,
  productName,
  ...props
}) => {
  const [hasItems, setHasItem] = _react.default.useState(items.length > 0);
  if (search.box && !search.box['data-test-subj']) {
    search.box['data-test-subj'] = 'monitoringTableToolBar';
  }
  if (search.box && !search.box.schema) {
    search.box.schema = true;
  }
  if (search) {
    const oldOnChange = search.onChange;
    search.onChange = arg => {
      const filteredItems = _eui.EuiSearchBar.Query.execute(arg.query, items, props.executeQueryOptions);
      setHasItem(filteredItems.length > 0);
      if (oldOnChange) {
        oldOnChange(arg);
      }
      return true;
    };
  }
  const columns = _columns.map(column => {
    if (!('sortable' in column)) {
      column.sortable = true;
    }
    return column;
  });
  let footerContent = null;
  if (setupMode && (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    footerContent = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "flag",
      onClick: () => setupMode.openFlyout({}, true)
    }, _i18n.i18n.translate('xpack.monitoring.euiTable.setupNewButtonLabel', {
      defaultMessage: 'Monitor another {identifier} with Metricbeat',
      values: {
        identifier: (0, _formatting.getIdentifier)(productName)
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${props.className}Container`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({
    "data-test-subj": items.length && hasItems === true ? 'monitoringTableHasData' : 'monitoringTableNoData',
    items: items,
    search: search,
    columns: columns
  }, props)), footerContent);
};
exports.EuiMonitoringTable = EuiMonitoringTable;