"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringToolbar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _use_monitoring_time = require("../../application/hooks/use_monitoring_time");
var _global_state_context = require("../../application/contexts/global_state_context");
var _legacy_shims = require("../../legacy_shims");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitoringToolbar = ({
  pageTitle,
  onRefresh
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const timePickerQuickRanges = services.uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = (0, _react.useMemo)(() => timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  })), [timePickerQuickRanges]);
  const {
    currentTimerange,
    handleTimeChange,
    setRefreshInterval,
    refreshInterval,
    setIsPaused,
    isPaused,
    isDisabled
  } = (0, _use_monitoring_time.useMonitoringTimeContainerContext)();
  const state = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const onTimeChange = (0, _react.useCallback)(selectedTime => {
    if (selectedTime.isInvalid) {
      return;
    }
    handleTimeChange(selectedTime.start, selectedTime.end);
  }, [handleTimeChange]);
  const onRefreshChange = (0, _react.useCallback)(({
    refreshInterval: ri,
    isPaused: isP
  }) => {
    var _state$save;
    setRefreshInterval(ri);
    setIsPaused(isP);
    state.refreshInterval = {
      pause: isP,
      value: ri
    };
    _legacy_shims.Legacy.shims.timefilter.setRefreshInterval(state.refreshInterval);
    (_state$save = state.save) === null || _state$save === void 0 ? void 0 : _state$save.call(state);
  }, [setRefreshInterval, setIsPaused, state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: pageTitle,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
      isDisabled: isDisabled,
      start: currentTimerange.from,
      end: currentTimerange.to,
      onTimeChange: onTimeChange,
      onRefresh: onRefresh,
      isPaused: isPaused,
      refreshInterval: refreshInterval,
      onRefreshChange: onRefreshChange,
      commonlyUsedRanges: commonlyUsedRanges
    })]
  });
};
exports.MonitoringToolbar = MonitoringToolbar;