"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labels = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The ui had different columns in different order depending on the
// $scope.view variable. This provides a lookup for the column headers

const labels = {
  // "index detail" page shows nodes on which index shards are allocated
  index: [{
    content: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.labels.nodesLabel', {
      defaultMessage: 'Nodes'
    })
  }],
  indexWithUnassigned: [{
    content: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.labels.unassignedLabel', {
      defaultMessage: 'Unassigned'
    })
  }, {
    content: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.labels.unassignedNodesLabel', {
      defaultMessage: 'Nodes'
    })
  }],
  // "node detail" page shows the indexes that have shards on this node
  node: [{
    content: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.labels.indicesLabel', {
      defaultMessage: 'Indices'
    }),
    showToggleSystemIndicesComponent: true // tell the TableHead component to inject checkbox JSX to show/hide system indices
  }]
};
exports.labels = labels;