"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HorizontalLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
require("./horizontal_legend.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class HorizontalLegend extends _react.default.Component {
  constructor() {
    super();
    this.formatter = this.formatter.bind(this);
    this.createSeries = this.createSeries.bind(this);
  }

  /**
   * @param {Number} value Final value to display
   */
  displayValue(value) {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "monRhythmChart__legendValue"
    }, value);
  }

  /**
   * @param {Number} value True if value is falsy and/or not a number
   */
  validValue(value) {
    return value !== null && value !== undefined && (typeof value === 'string' || !isNaN(value));
  }

  /**
   * @param {Number} value The value to format and show in the horizontallegend.
   * A null means no data for the time bucket and will be formatted as 'N/A'
   * @param {Object} row Props passed form a parent by row index
   */
  formatter(value, row) {
    if (!this.validValue(value)) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.chart.horizontalLegend.notAvailableLabel",
        defaultMessage: "N/A"
      });
    }
    if (row && row.tickFormatter) {
      return this.displayValue(row.tickFormatter(value));
    }
    if ((0, _lodash.isFunction)(this.props.tickFormatter)) {
      return this.displayValue(this.props.tickFormatter(value));
    }
    return this.displayValue(value);
  }
  createSeries(row, rowIdx) {
    const classes = ['monRhythmChart__legendItem'];
    if (!(0, _lodash.includes)(this.props.seriesFilter, row.id)) {
      classes.push('monRhythmChart__legendItem-isDisabled');
    }
    if (!row.label || row.legend === false) {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: rowIdx,
        style: {
          display: 'none'
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: rowIdx
    }, /*#__PURE__*/_react.default.createElement("button", {
      className: classes.join(' '),
      onClick: event => this.props.onToggle(event, row.id)
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "monRhythmChart__legendLabel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "monRhythmChart__legendIndicator",
      "aria-label": _i18n.i18n.translate('xpack.monitoring.chart.horizontalLegend.toggleButtonAriaLabel', {
        defaultMessage: 'toggle button'
      }),
      size: "l",
      type: "dot",
      color: row.color
    }), ' ' + row.label + ' '), this.formatter(this.props.seriesValues[row.id], row)));
  }
  render() {
    const rows = this.props.series.map(this.createSeries);
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "monRhythmChart__legendHorizontal"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      gutterSize: "s",
      className: "monRhythmChart__legendSeries"
    }, rows));
  }
}
exports.HorizontalLegend = HorizontalLegend;