"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _replace_tokens = require("./lib/replace_tokens");
var _setup_mode = require("../lib/setup_mode");
var _setup_mode_context = require("../components/setup_mode/setup_mode_context");
var _configuration = require("./configuration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsCallout = props => {
  const {
    alerts
  } = props;
  const inSetupMode = (0, _setup_mode.isInSetupMode)(_react.default.useContext(_setup_mode_context.SetupModeContext));
  if (inSetupMode) {
    return null;
  }
  // get a list of each alert state for each rule
  const list = Object.values(alerts).flat().map(alert => alert.states.map(state => ({
    alert,
    state
  }))).flat();
  if (list.length === 0) {
    return null;
  }
  const accordions = list.map((status, index) => {
    const buttonContent = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      size: "m",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "danger"
    }, (0, _replace_tokens.replaceTokens)(status.state.state.ui.message)))));
    const {
      code
    } = status.state.state.ui.message;
    const accordion = /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `monitoringAlertCallout_${index}`,
      buttonContent: buttonContent,
      paddingSize: "s"
    }, code !== null && code !== void 0 && code.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      fontSize: "s",
      paddingSize: "s",
      language: "json",
      isCopyable: true,
      overflowHeight: 300
    }, code) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
      flush: true,
      bordered: true,
      gutterSize: "m",
      size: "xs",
      style: {
        marginTop: '0.5rem',
        paddingTop: '0.5rem',
        paddingBottom: '0.5rem',
        paddingLeft: `0.5rem`
      }
    }, (status.state.state.ui.message.nextSteps || []).map((step, stepIndex) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
        onClick: () => {},
        label: (0, _replace_tokens.replaceTokens)(step),
        key: index + stepIndex
      });
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
      label: /*#__PURE__*/_react.default.createElement(_configuration.AlertConfiguration, {
        alert: status.alert.sanitizedRule,
        key: index,
        compressed: true
      })
    })));
    const spacer = index !== list.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null) : null;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index
    }, accordion, spacer);
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, accordions), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AlertsCallout = AlertsCallout;