"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLWorker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr4ts = require("antlr4ts");
var _autocomplete_listener = require("../lib/autocomplete/autocomplete_listener");
var _antlr_facade = require("../lib/antlr_facade");
var _error_listener = require("../../common/error_listener");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ESQLWorker {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "_ctx", void 0);
    this._ctx = ctx;
  }
  getModelCharStream(modelUri) {
    const model = this._ctx.getMirrorModels().find(m => m.uri.toString() === modelUri);
    const text = model === null || model === void 0 ? void 0 : model.getValue();
    if (text) {
      return _antlr4ts.CharStreams.fromString(text);
    }
  }
  async getSyntaxErrors(modelUri) {
    const inputStream = this.getModelCharStream(modelUri);
    if (inputStream) {
      const errorListener = new _error_listener.ANTLREErrorListener();
      const parser = (0, _antlr_facade.getParser)(inputStream, errorListener);
      parser[_antlr_facade.ROOT_STATEMENT]();
      return errorListener.getErrors();
    }
    return [];
  }
  async provideAutocompleteSuggestions(modelUri, meta) {
    const inputStream = this.getModelCharStream(modelUri);
    if (inputStream) {
      const errorListener = new _error_listener.ANTLREErrorListener();
      const parseListener = new _autocomplete_listener.AutocompleteListener();
      const parser = (0, _antlr_facade.getParser)(inputStream, errorListener, parseListener);
      parser[_antlr_facade.ROOT_STATEMENT]();
      return parseListener.getAutocompleteSuggestions();
    }
  }
}
exports.ESQLWorker = ESQLWorker;