"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_SWIMLANE_PANEL_ACTION = void 0;
exports.createEditSwimlanePanelAction = createEditSwimlanePanelAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _embeddables = require("../embeddables");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const EDIT_SWIMLANE_PANEL_ACTION = 'editSwimlanePanelAction';
exports.EDIT_SWIMLANE_PANEL_ACTION = EDIT_SWIMLANE_PANEL_ACTION;
function createEditSwimlanePanelAction(getStartServices) {
  return {
    id: 'edit-anomaly-swimlane',
    type: EDIT_SWIMLANE_PANEL_ACTION,
    getIconType(context) {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.editSwimlaneTitle', {
      defaultMessage: 'Edit swim lane'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const [coreStart] = await getStartServices();
      try {
        const {
          resolveAnomalySwimlaneUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/anomaly_swimlane/anomaly_swimlane_setup_flyout')));
        const result = await resolveAnomalySwimlaneUserInput(coreStart, embeddable.getInput());
        embeddable.updateInput(result);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _embeddables.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE && embeddable.getInput().viewMode === _public.ViewMode.EDIT;
    }
  };
}