"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_ANOMALY = exports.AnomalyLayerWizardFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/maps-plugin/common");
var _locator = require("../../common/constants/locator");
var _util = require("./util");
var _create_anomaly_source_editor = require("./create_anomaly_source_editor");
var _anomaly_source = require("./anomaly_source");
var _http_service = require("../application/services/http_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ML_ANOMALY = 'ML_ANOMALIES';
exports.ML_ANOMALY = ML_ANOMALY;
class AnomalyLayerWizardFactory {
  constructor(getStartServices, canGetJobs, canCreateJobs) {
    (0, _defineProperty2.default)(this, "type", ML_ANOMALY);
    this.getStartServices = getStartServices;
    this.canGetJobs = canGetJobs;
    this.canCreateJobs = canCreateJobs;
    this.canGetJobs = canGetJobs;
    this.canCreateJobs = canCreateJobs;
  }
  async getServices() {
    const [coreStart, pluginStart] = await this.getStartServices();
    const {
      jobsApiProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/services/ml_api_service/jobs')));
    const httpService = new _http_service.HttpService(coreStart.http);
    const mlJobsService = jobsApiProvider(httpService);
    const mlLocator = pluginStart.share.url.locators.get(_locator.ML_APP_LOCATOR);
    return {
      mlJobsService,
      mlLocator
    };
  }
  async create() {
    const {
      mlJobsService,
      mlLocator
    } = await this.getServices();
    let jobsManagementPath;
    if (mlLocator) {
      jobsManagementPath = await mlLocator.getUrl({
        page: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE
      });
    } else {
      // eslint-disable-next-line no-console
      console.error('Unable to get job management path.');
    }
    const {
      anomalyLayerWizard
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_layer_wizard')));
    anomalyLayerWizard.getIsDisabled = () => !this.canGetJobs;
    anomalyLayerWizard.renderWizard = ({
      previewLayers
    }) => {
      const onSourceConfigChange = sourceConfig => {
        if (!sourceConfig) {
          previewLayers([]);
          return;
        }
        const anomalyLayerDescriptor = {
          id: (0, _eui.htmlIdGenerator)()(),
          type: _common.LAYER_TYPE.GEOJSON_VECTOR,
          sourceDescriptor: _anomaly_source.AnomalySource.createDescriptor({
            jobId: sourceConfig.jobId,
            typicalActual: sourceConfig.typicalActual
          }),
          style: {
            type: 'VECTOR',
            properties: {
              fillColor: _util.CUSTOM_COLOR_RAMP,
              lineColor: _util.CUSTOM_COLOR_RAMP
            },
            isTimeAware: false
          }
        };
        previewLayers([anomalyLayerDescriptor]);
      };
      return /*#__PURE__*/_react.default.createElement(_create_anomaly_source_editor.CreateAnomalySourceEditor, {
        onSourceConfigChange: onSourceConfigChange,
        mlJobsService: mlJobsService,
        jobsManagementPath: jobsManagementPath,
        canCreateJobs: this.canCreateJobs
      });
    };
    return anomalyLayerWizard;
  }
}
exports.AnomalyLayerWizardFactory = AnomalyLayerWizardFactory;