"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddableExecutionContext = useEmbeddableExecutionContext;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _operators = require("rxjs/operators");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Use execution context for ML embeddables.
 * @param executionContext
 * @param embeddableInput$
 * @param embeddableType
 * @param id
 */
function useEmbeddableExecutionContext(executionContext, embeddableInput$, embeddableType, id) {
  const parentExecutionContext = (0, _useObservable.default)(embeddableInput$.pipe((0, _operators.map)(v => v.executionContext)));
  const embeddableExecutionContext = (0, _react.useMemo)(() => {
    const child = {
      type: 'visualization',
      name: embeddableType,
      id
    };
    return {
      ...parentExecutionContext,
      child
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [parentExecutionContext, id]);
  (0, _public.useExecutionContext)(executionContext, embeddableExecutionContext);
}