"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListUsagePopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React popover listing the jobs or detectors using a particular filter list in a custom rule.
 */

class FilterListUsagePopover extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    this.state = {
      isPopoverOpen: false
    };
  }
  render() {
    const {
      entityType,
      entityValues
    } = this.props;
    const linkText = `${entityValues.length} ${entityType}${entityValues.length !== 1 ? 's' : ''}`;
    const listItems = entityValues.map(value => /*#__PURE__*/_react.default.createElement("li", {
      key: value
    }, value));
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "primary",
      onClick: this.onButtonClick
    }, linkText);
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: `${entityType}_filter_list_usage`,
      panelClassName: "ml-filter-list-usage-popover",
      ownFocus: true,
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover
    }, /*#__PURE__*/_react.default.createElement("ul", null, listItems)));
  }
}
exports.FilterListUsagePopover = FilterListUsagePopover;
FilterListUsagePopover.propTypes = {
  entityType: _propTypes.default.oneOf(['job', 'detector']),
  entityValues: _propTypes.default.array.isRequired
};