"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNerOutputComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _inference_base = require("../inference_base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_PADDING = '2px';
const PROBABILITY_SIG_FIGS = 3;
const ENTITY_TYPES = {
  PER: {
    label: 'Person',
    icon: 'user',
    color: 'euiColorVis5_behindText',
    borderColor: 'euiColorVis5'
  },
  LOC: {
    label: 'Location',
    icon: 'visMapCoordinate',
    color: 'euiColorVis1_behindText',
    borderColor: 'euiColorVis1'
  },
  ORG: {
    label: 'Organization',
    icon: 'home',
    color: 'euiColorVis0_behindText',
    borderColor: 'euiColorVis0'
  },
  MISC: {
    label: 'Miscellaneous',
    icon: 'questionInCircle',
    color: 'euiColorVis7_behindText',
    borderColor: 'euiColorVis7'
  }
};
const UNKNOWN_ENTITY_TYPE = {
  label: '',
  icon: 'questionInCircle',
  color: 'euiColorVis5_behindText',
  borderColor: 'euiColorVis5'
};
const getNerOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(NerOutput, {
  inferrer: inferrer
});
exports.getNerOutputComponent = getNerOutputComponent;
const NerOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  if (inferrer.getInputType() === _inference_base.INPUT_TYPE.INDEX) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(r => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Lines, {
      result: r
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))));
  }
  return /*#__PURE__*/_react.default.createElement(Lines, {
    result: result[0]
  });
};
const Lines = ({
  result
}) => {
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  const lineSplit = [];
  result.response.forEach(({
    value,
    entity
  }) => {
    if (entity === null) {
      const lines = value.split(/(\n)/).map(line => line === '\n' ? /*#__PURE__*/_react.default.createElement("br", null) : /*#__PURE__*/_react.default.createElement("span", null, line));
      lineSplit.push(...lines);
    } else {
      lineSplit.push( /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: getClassIcon(entity.class_name),
          style: {
            marginRight: ICON_PADDING,
            verticalAlign: 'text-top'
          }
        }), value), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          margin: "none"
        }), /*#__PURE__*/_react.default.createElement("div", {
          style: {
            fontSize: euiTheme.euiFontSizeXS,
            marginTop: ICON_PADDING
          }
        }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.testModelsFlyout.ner.output.typeTitle",
          defaultMessage: "Type"
        }), ": ", getClassLabel(entity.class_name)), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.testModelsFlyout.ner.output.probabilityTitle",
          defaultMessage: "Probability"
        }), ": ", Number(entity.class_probability).toPrecision(PROBABILITY_SIG_FIGS))))
      }, /*#__PURE__*/_react.default.createElement(EntityBadge, {
        entity: entity
      }, value)));
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      lineHeight: '24px'
    }
  }, lineSplit);
};
const EntityBadge = ({
  entity,
  children
}) => {
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge
  // @ts-expect-error colors are correct in ENTITY_TYPES
  , {
    color: getClassColor(euiTheme, entity.class_name),
    style: {
      marginRight: ICON_PADDING,
      marginTop: `-${ICON_PADDING}`,
      border: `1px solid ${getClassColor(euiTheme, entity.class_name, true)}`,
      fontSize: euiTheme.euiFontSizeXS,
      padding: '0px 6px',
      pointerEvents: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: getClassIcon(entity.class_name),
    style: {
      marginRight: ICON_PADDING,
      marginTop: ICON_PADDING
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children)));
};
function getClassIcon(className) {
  var _entity$icon;
  const entity = ENTITY_TYPES[className];
  return (_entity$icon = entity === null || entity === void 0 ? void 0 : entity.icon) !== null && _entity$icon !== void 0 ? _entity$icon : UNKNOWN_ENTITY_TYPE.icon;
}
function getClassLabel(className) {
  var _entity$label;
  const entity = ENTITY_TYPES[className];
  return (_entity$label = entity === null || entity === void 0 ? void 0 : entity.label) !== null && _entity$label !== void 0 ? _entity$label : className;
}
function getClassColor(euiTheme, className, border = false) {
  var _entity$color;
  const entity = ENTITY_TYPES[className];
  let color = (_entity$color = entity === null || entity === void 0 ? void 0 : entity.color) !== null && _entity$color !== void 0 ? _entity$color : UNKNOWN_ENTITY_TYPE.color;
  if (border) {
    var _entity$borderColor;
    color = (_entity$borderColor = entity === null || entity === void 0 ? void 0 : entity.borderColor) !== null && _entity$borderColor !== void 0 ? _entity$borderColor : UNKNOWN_ENTITY_TYPE.borderColor;
  }
  return euiTheme[color];
}