"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexInputForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _inference_error = require("../../inference_error");
var _index_input = require("../index_input");
var _inference_base = require("../inference_base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexInputForm = ({
  inferrer
}) => {
  const data = (0, _index_input.useIndexInput)({
    inferrer
  });
  const {
    reloadExamples,
    selectedField
  } = data;
  const [errorText, setErrorText] = (0, _react.useState)(null);
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const examples = (0, _useObservable.default)(inferrer.getInputText$(), inferrer.getInputText());
  const isValid = (0, _useObservable.default)(inferrer.getIsValid$(), inferrer.getIsValid());
  const outputComponent = (0, _react.useMemo)(() => inferrer.getOutputComponent(), [inferrer]);
  const infoComponent = (0, _react.useMemo)(() => inferrer.getInfoComponent(), [inferrer]);
  const run = (0, _react.useCallback)(async event => {
    event.preventDefault();
    setErrorText(null);
    try {
      await inferrer.infer();
    } catch (e) {
      setErrorText((0, _mlErrorUtils.extractErrorMessage)(e));
    }
  }, [inferrer]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: 'form',
    onSubmit: run
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, infoComponent), /*#__PURE__*/_react.default.createElement(_index_input.InferenceInputFormIndexControls, {
    inferrer: inferrer,
    data: data
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING || isValid === false,
    fullWidth: false,
    "data-test-subj": 'mlTestModelTestButton',
    type: 'submit'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.runButton",
    defaultMessage: "Test"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, runningState === _inference_base.RUNNING_STATE.RUNNING ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: reloadExamples,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING || selectedField === undefined
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.reloadButton",
    defaultMessage: "Reload examples"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), errorText !== null || runningState === _inference_base.RUNNING_STATE.FINISHED_WITH_ERRORS ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inference_error.ErrorMessage, {
    errorText: errorText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, runningState !== _inference_base.RUNNING_STATE.FINISHED ? examples.map(example => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, example), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))) : null, runningState === _inference_base.RUNNING_STATE.FINISHED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, outputComponent) : null);
};
exports.IndexInputForm = IndexInputForm;