"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultModelsListState = exports.ModelsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _trained_models = require("@kbn/ml-trained-models-utils/src/constants/trained_models");
var _technical_preview_badge = require("../components/technical_preview_badge");
var _model_actions = require("./model_actions");
var _ = require(".");
var _stats_bar = require("../components/stats_bar");
var _kibana = require("../contexts/kibana");
var _trained_models2 = require("../services/ml_api_service/trained_models");
var _delete_models_modal = require("./delete_models_modal");
var _locator = require("../../../common/constants/locator");
var _expanded_row = require("./expanded_row");
var _use_table_settings = require("../data_frame_analytics/pages/analytics_management/components/analytics_list/use_table_settings");
var _toast_notification_service = require("../services/toast_notification_service");
var _use_field_formatter = require("../contexts/kibana/use_field_formatter");
var _use_refresh = require("../routing/use_refresh");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _test_models = require("./test_models");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultModelsListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: _.ModelsTableToConfigMapping.id,
  sortDirection: 'asc'
});
exports.getDefaultModelsListState = getDefaultModelsListState;
const ModelsList = ({
  pageState: pageStateExternal,
  updatePageState: updatePageStateExternal
}) => {
  var _pageState$queryText;
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);

  // allow for an internally controlled page state which stores the state in the URL
  // or an external page state, which is passed in as a prop.
  // external page state is used on the management page.
  const [pageStateInternal, updatePageStateInternal] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE, getDefaultModelsListState());
  const [pageState, updatePageState] = pageStateExternal && updatePageStateExternal ? [pageStateExternal, updatePageStateExternal] : [pageStateInternal, updatePageStateInternal];
  const refresh = (0, _use_refresh.useRefresh)();
  const searchQueryText = (_pageState$queryText = pageState.queryText) !== null && _pageState$queryText !== void 0 ? _pageState$queryText : '';
  const canDeleteTrainedModels = capabilities.ml.canDeleteTrainedModels;
  const trainedModelsApiService = (0, _trained_models2.useTrainedModelsApiService)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const [selectedModels, setSelectedModels] = (0, _react.useState)([]);
  const [modelsToDelete, setModelsToDelete] = (0, _react.useState)([]);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [modelToTest, setModelToTest] = (0, _react.useState)(null);
  const isBuiltInModel = (0, _react.useCallback)(item => item.tags.includes(_mlTrainedModelsUtils.BUILT_IN_MODEL_TAG), []);
  const isElasticModel = (0, _react.useCallback)(item => item.tags.includes(_trained_models.ELASTIC_MODEL_TAG), []);

  /**
   * Checks if the model download complete.
   */
  const isDownloadComplete = (0, _react.useCallback)(async modelId => {
    try {
      var _response$;
      const response = await trainedModelsApiService.getTrainedModels(modelId, {
        include: 'definition_status'
      });
      // @ts-ignore
      return !!((_response$ = response[0]) !== null && _response$ !== void 0 && _response$.fully_defined);
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.downloadStatusCheckErrorMessage', {
        defaultMessage: 'Failed to check download status'
      }));
    }
    return false;
  }, [trainedModelsApiService, displayErrorToast]);

  /**
   * Fetches trained models.
   */
  const fetchModelsData = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const response = await trainedModelsApiService.getTrainedModels(undefined, {
        with_pipelines: true,
        size: 1000
      });
      const newItems = [];
      const expandedItemsToRefresh = [];
      for (const model of response) {
        const tableItem = {
          ...model,
          // Extract model types
          ...(typeof model.inference_config === 'object' ? {
            type: [model.model_type, ...Object.keys(model.inference_config), ...(isBuiltInModel(model) ? [_mlTrainedModelsUtils.BUILT_IN_MODEL_TYPE] : []), ...(isElasticModel(model) ? [_trained_models.ELASTIC_MODEL_TYPE] : [])]
          } : {})
        };
        newItems.push(tableItem);
        if (itemIdToExpandedRowMap[model.model_id]) {
          expandedItemsToRefresh.push(tableItem);
        }
      }

      // Need to fetch stats for all models to enable/disable actions
      // TODO combine fetching models definitions and stats into a single function
      await fetchModelsStats(newItems);
      setItems(newItems);
      if (expandedItemsToRefresh.length > 0) {
        await fetchModelsStats(expandedItemsToRefresh);
        setItemIdToExpandedRowMap(expandedItemsToRefresh.reduce((acc, item) => {
          acc[item.model_id] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
            item: item
          });
          return acc;
        }, {}));
      }
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.fetchFailedErrorMessage', {
        defaultMessage: 'Models fetch failed'
      }));
    }
    setIsLoading(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [itemIdToExpandedRowMap]);
  (0, _react.useEffect)(function updateOnTimerRefresh() {
    if (!refresh) return;
    fetchModelsData();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [refresh]);
  const modelsStats = (0, _react.useMemo)(() => {
    return {
      total: {
        show: true,
        value: items.length,
        label: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.totalAmountLabel', {
          defaultMessage: 'Total trained models'
        })
      }
    };
  }, [items]);

  /**
   * Fetches models stats and update the original object
   */
  const fetchModelsStats = (0, _react.useCallback)(async models => {
    try {
      if (models) {
        const {
          trained_model_stats: modelsStatsResponse
        } = await trainedModelsApiService.getTrainedModelStats(models.map(m => m.model_id));
        const groupByModelId = (0, _lodash.groupBy)(modelsStatsResponse, 'model_id');
        models.forEach(model => {
          var _model$stats, _model$stats$deployme;
          const modelStats = groupByModelId[model.model_id];
          model.stats = {
            ...((_model$stats = model.stats) !== null && _model$stats !== void 0 ? _model$stats : {}),
            ...modelStats[0],
            deployment_stats: modelStats.map(d => d.deployment_stats).filter(_mlIsDefined.isDefined)
          };
          model.deployment_ids = modelStats.map(v => {
            var _v$deployment_stats;
            return (_v$deployment_stats = v.deployment_stats) === null || _v$deployment_stats === void 0 ? void 0 : _v$deployment_stats.deployment_id;
          }).filter(_mlIsDefined.isDefined);
          model.state = (_model$stats$deployme = model.stats.deployment_stats) !== null && _model$stats$deployme !== void 0 && _model$stats$deployme.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED) ? _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED : null;
        });
        const elasticModels = models.filter(model => _trained_models.ELASTIC_MODEL_DEFINITIONS.hasOwnProperty(model.model_id));
        if (elasticModels.length > 0) {
          for (const model of elasticModels) {
            if (model.state === _trained_models.MODEL_STATE.STARTED) {
              // no need to check for the download status if the model has been deployed
              continue;
            }
            const isDownloaded = await isDownloadComplete(model.model_id);
            model.state = isDownloaded ? _trained_models.MODEL_STATE.DOWNLOADED : _trained_models.MODEL_STATE.DOWNLOADING;
          }
        }
      }
      return true;
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.fetchModelStatsErrorMessage', {
        defaultMessage: 'Fetch model stats failed'
      }));
      return false;
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  /**
   * Unique inference types from models
   */
  const inferenceTypesOptions = (0, _react.useMemo)(() => {
    const result = items.reduce((acc, item) => {
      const type = item.inference_config && Object.keys(item.inference_config)[0];
      if (type) {
        acc.add(type);
      }
      acc.add(item.model_type);
      return acc;
    }, new Set());
    return [...result].sort((a, b) => a.localeCompare(b)).map(v => ({
      value: v,
      name: v
    }));
  }, [items]);
  const modelAndDeploymentIds = (0, _react.useMemo)(() => [...new Set([...items.flatMap(v => v.deployment_ids), ...items.map(i => i.model_id)])], [items]);

  /**
   * Table actions
   */
  const actions = (0, _model_actions.useModelActions)({
    isLoading,
    fetchModels: fetchModelsData,
    onTestAction: setModelToTest,
    onModelsDeleteRequest: setModelsToDelete,
    onLoading: setIsLoading,
    modelAndDeploymentIds
  });
  const toggleDetails = async item => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[item.model_id]) {
      delete itemIdToExpandedRowMapValues[item.model_id];
    } else {
      await fetchModelsStats([item]);
      itemIdToExpandedRowMapValues[item.model_id] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        item: item
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const columns = [{
    align: 'left',
    width: '40px',
    isExpander: true,
    render: item => {
      if (!item.stats) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: toggleDetails.bind(null, item),
        "aria-label": itemIdToExpandedRowMap[item.model_id] ? _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.collapseRow', {
          defaultMessage: 'Collapse'
        }) : _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.expandRow', {
          defaultMessage: 'Expand'
        }),
        iconType: itemIdToExpandedRowMap[item.model_id] ? 'arrowDown' : 'arrowRight'
      });
    },
    'data-test-subj': 'mlModelsTableRowDetailsToggle'
  }, {
    field: _.ModelsTableToConfigMapping.id,
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelIdHeader', {
      defaultMessage: 'ID'
    }),
    sortable: true,
    truncateText: false,
    'data-test-subj': 'mlModelsTableColumnId'
  }, {
    field: _.ModelsTableToConfigMapping.description,
    width: '350px',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelDescriptionHeader', {
      defaultMessage: 'Description'
    }),
    sortable: false,
    truncateText: false,
    'data-test-subj': 'mlModelsTableColumnDescription',
    render: description => {
      if (!description) return null;
      const isTechPreview = description.includes('(Tech Preview)');
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description.replace('(Tech Preview)', ''), isTechPreview ? /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
        compressed: true
      }) : null);
    }
  }, {
    field: _.ModelsTableToConfigMapping.type,
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.typeHeader', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    truncateText: true,
    align: 'left',
    render: types => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'xs',
      wrap: true
    }, types.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: type,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": "mlModelType"
    }, type)))),
    'data-test-subj': 'mlModelsTableColumnType'
  }, {
    field: 'state',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.stateHeader', {
      defaultMessage: 'State'
    }),
    align: 'left',
    truncateText: false,
    render: state => {
      return state ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, state) : null;
    },
    'data-test-subj': 'mlModelsTableColumnDeploymentState'
  }, {
    field: _.ModelsTableToConfigMapping.createdAt,
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.createdAtHeader', {
      defaultMessage: 'Created at'
    }),
    dataType: 'date',
    render: v => dateFormatter(v),
    sortable: true,
    'data-test-subj': 'mlModelsTableColumnCreatedAt'
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.actionsHeader', {
      defaultMessage: 'Actions'
    }),
    actions,
    'data-test-subj': 'mlModelsTableColumnActions'
  }];
  const filters = inferenceTypesOptions && inferenceTypesOptions.length > 0 ? [{
    type: 'field_value_selection',
    field: 'type',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.typeFilter', {
      defaultMessage: 'Type'
    }),
    multiSelect: 'or',
    options: inferenceTypesOptions
  }] : [];
  const toolsLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.selectedModelsMessage",
    defaultMessage: "{modelsCount, plural, one{# model} other {# models}} selected",
    values: {
      modelsCount: selectedModels.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: setModelsToDelete.bind(null, selectedModels)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModelsButtonLabel",
    defaultMessage: "Delete"
  })))));
  const isSelectionAllowed = canDeleteTrainedModels;
  const selection = isSelectionAllowed ? {
    selectableMessage: (selectable, item) => {
      if (selectable) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.selectableMessage', {
          defaultMessage: 'Select a model'
        });
      }
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.disableSelectableMessage', {
          defaultMessage: 'Model has associated pipelines'
        });
      }
      if (isBuiltInModel(item)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.builtInModelMessage', {
          defaultMessage: 'Built-in model'
        });
      }
      return '';
    },
    selectable: item => !(0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines) && !isBuiltInModel(item) && !(isElasticModel(item) && !item.state),
    onSelectionChange: selectedItems => {
      setSelectedModels(selectedItems);
    }
  } : undefined;
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _use_table_settings.useTableSettings)(items.length, pageState, updatePageState);
  const search = {
    query: searchQueryText,
    onChange: searchChange => {
      if (searchChange.error !== null) {
        return false;
      }
      updatePageState({
        queryText: searchChange.queryText,
        pageIndex: 0
      });
      return true;
    },
    box: {
      incremental: true
    },
    ...(inferenceTypesOptions && inferenceTypesOptions.length > 0 ? {
      filters
    } : {}),
    ...(selectedModels.length > 0 ? {
      toolsLeft
    } : {})
  };
  const resultItems = (0, _react.useMemo)(() => {
    const idSet = new Set(items.map(i => i.model_id));
    const notDownloaded = Object.entries(_trained_models.ELASTIC_MODEL_DEFINITIONS).filter(([modelId]) => !idSet.has(modelId)).map(([modelId, modelDefinition]) => {
      return {
        model_id: modelId,
        type: [_trained_models.ELASTIC_MODEL_TYPE],
        tags: [_trained_models.ELASTIC_MODEL_TAG],
        putModelConfig: modelDefinition.config,
        description: modelDefinition.description
      };
    });
    return [...items, ...notDownloaded];
  }, [items]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: fetchModelsData,
    forceRefresh: isLoading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, modelsStats && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: modelsStats,
    dataTestSub: 'mlInferenceModelsStatsBar'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlModelsTableContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    columns: columns,
    hasActions: true,
    isExpandable: true,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    isSelectable: false,
    items: resultItems,
    itemId: _.ModelsTableToConfigMapping.id,
    loading: isLoading,
    search: search,
    selection: selection,
    rowProps: item => ({
      'data-test-subj': `mlModelsTableRow row-${item.model_id}`
    }),
    pagination: pagination,
    onTableChange: onTableChange,
    sorting: sorting,
    "data-test-subj": isLoading ? 'mlModelsTable loading' : 'mlModelsTable loaded'
  })), modelsToDelete.length > 0 && /*#__PURE__*/_react.default.createElement(_delete_models_modal.DeleteModelsModal, {
    onClose: refreshList => {
      setModelsToDelete([]);
      if (refreshList) {
        fetchModelsData();
      }
    },
    models: modelsToDelete
  }), modelToTest === null ? null : /*#__PURE__*/_react.default.createElement(_test_models.TestTrainedModelFlyout, {
    model: modelToTest,
    onClose: setModelToTest.bind(null, null)
  }));
};
exports.ModelsList = ModelsList;