"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../contexts/kibana");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TrainedModelLink = ({
  id
}) => {
  const href = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.TRAINED_MODELS_MANAGE,
    pageState: {
      modelId: id
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    css: {
      overflow: 'hidden',
      'text-overflow': 'ellipsis'
    },
    title: id
  }, id);
};
exports.TrainedModelLink = TrainedModelLink;