"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllocatedModels = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AllocatedModels = ({
  models,
  hideColumns = ['node_name']
}) => {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  const durationFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DURATION);
  const euiTheme = (0, _eui.useEuiTheme)();
  const columns = [{
    id: 'deployment_id',
    field: 'deployment_id',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.deploymentIdHeader', {
      defaultMessage: 'ID'
    }),
    width: '150px',
    sortable: true,
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableDeploymentId'
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelRoutingStateHeader', {
      defaultMessage: 'Routing state'
    }),
    width: '100px',
    'data-test-subj': 'mlAllocatedModelsTableRoutingState',
    render: v => {
      const {
        routing_state: routingState,
        reason
      } = v.node.routing_state;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: reason ? reason : ''
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: reason ? 'danger' : 'hollow'
      }, routingState));
    }
  }, {
    id: 'node_name',
    field: 'node.name',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.nodeNameHeader', {
      defaultMessage: 'Node name'
    }),
    width: '150px',
    sortable: true,
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableNodeName'
  }, {
    id: 'model_id',
    field: 'model_id',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelNameHeader', {
      defaultMessage: 'Name'
    }),
    width: '250px',
    sortable: true,
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableName'
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelSizeHeader', {
      defaultMessage: 'Size'
    }),
    width: '100px',
    truncateText: true,
    'data-test-subj': 'mlAllocatedModelsTableSize',
    render: v => {
      return bytesFormatter(v.required_native_memory_bytes);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.allocationTooltip', {
        defaultMessage: 'number_of_allocations times threads_per_allocation'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.allocationHeader', {
      defaultMessage: 'Allocation'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    width: '100px',
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableAllocation',
    render: v => {
      return `${v.node.number_of_allocations} * ${v.node.threads_per_allocation}`;
    }
  }, {
    field: 'node.throughput_last_minute',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.throughputLastMinuteHeader', {
      defaultMessage: 'Throughput'
    }),
    width: '100px',
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableThroughput'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: 'block',
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.nodesList.modelsList.modelAvgInferenceTimeTooltipHeader",
        defaultMessage: "Average inference time"
      }),
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.nodesList.modelsList.modelAvgInferenceTimeTooltipMessage",
        defaultMessage: "If caching is enabled, fast cache hits are included when calculating the average inference time."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        minWidth: 0
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: {
        overflow: 'hidden',
        textOverflow: 'ellipsis'
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.nodesList.modelsList.modelAvgInferenceTimeHeader",
      defaultMessage: "Avg inference time"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        minWidth: euiTheme.euiTheme.size.m
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    })))),
    width: '100px',
    truncateText: false,
    'data-test-subj': 'mlAllocatedModelsTableAvgInferenceTime',
    render: v => {
      return v.node.average_inference_time_ms ? durationFormatter(v.node.average_inference_time_ms) : '-';
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelInferenceCountHeader', {
      defaultMessage: 'Inference count'
    }),
    width: '100px',
    'data-test-subj': 'mlAllocatedModelsTableInferenceCount',
    render: v => {
      return v.node.inference_count;
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelStartTimeHeader', {
      defaultMessage: 'Start time'
    }),
    width: '200px',
    'data-test-subj': 'mlAllocatedModelsTableStartedTime',
    render: v => {
      return dateFormatter(v.node.start_time);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelLastAccessHeader', {
      defaultMessage: 'Last access'
    }),
    width: '200px',
    'data-test-subj': 'mlAllocatedModelsTableInferenceCount',
    render: v => {
      return v.node.last_access ? dateFormatter(v.node.last_access) : '-';
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.modelNumberOfPendingRequestsHeader', {
      defaultMessage: 'Pending requests'
    }),
    width: '100px',
    'data-test-subj': 'mlAllocatedModelsTableNumberOfPendingRequests',
    render: v => {
      return v.node.number_of_pending_requests;
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.nodesList.modelsList.errorCountHeader', {
      defaultMessage: 'Errors'
    }),
    width: '60px',
    'data-test-subj': 'mlAllocatedModelsTableErrorCount',
    render: v => {
      var _v$node$error_count;
      return (_v$node$error_count = v.node.error_count) !== null && _v$node$error_count !== void 0 ? _v$node$error_count : 0;
    }
  }].filter(v => !hideColumns.includes(v.id));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    columns: columns,
    hasActions: false,
    isExpandable: false,
    isSelectable: false,
    items: models,
    itemId: 'key',
    rowProps: item => ({
      'data-test-subj': `mlAllocatedModelTableRow row-${item.model_id}`
    }),
    onTableChange: () => {},
    "data-test-subj": 'mlNodesAllocatedModels',
    css: {
      overflow: 'auto'
    }
  });
};
exports.AllocatedModels = AllocatedModels;