"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_QUERY = void 0;
exports.checkCardinalitySuccess = checkCardinalitySuccess;
exports.createQueries = createQueries;
exports.createSearchItems = createSearchItems;
exports.getDefaultDatafeedQuery = getDefaultDatafeedQuery;
exports.getDefaultQuery = getDefaultQuery;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _search = require("../../../../../common/constants/search");
var _index_utils = require("../../../util/index_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Provider for creating the items used for searching and job creation.

const DEFAULT_DSL_QUERY = {
  bool: {
    must: [{
      match_all: {}
    }]
  }
};
const DEFAULT_QUERY = {
  query: '',
  language: 'lucene'
};
exports.DEFAULT_QUERY = DEFAULT_QUERY;
function getDefaultDatafeedQuery() {
  return (0, _lodash.cloneDeep)(DEFAULT_DSL_QUERY);
}
function getDefaultQuery() {
  return (0, _lodash.cloneDeep)(DEFAULT_QUERY);
}
function createSearchItems(kibanaConfig, indexPattern, savedSearch) {
  // query is only used by the data visualizer as it needs
  // a lucene query_string.
  // Using a blank query will cause match_all:{} to be used
  // when passed through luceneStringToDsl
  if (savedSearch === null) {
    return {
      query: getDefaultQuery(),
      combinedQuery: getDefaultDatafeedQuery()
    };
  }
  const data = (0, _index_utils.getQueryFromSavedSearchObject)(savedSearch);
  return createQueries(data, indexPattern, kibanaConfig);
}
function createQueries(data, dataView, kibanaConfig) {
  let query = getDefaultQuery();
  let combinedQuery = getDefaultDatafeedQuery();
  query = data.query;
  const filter = data.filter;
  const filters = Array.isArray(filter) ? filter : [];
  if (query.language === _search.SEARCH_QUERY_LANGUAGE.KUERY) {
    const ast = (0, _esQuery.fromKueryExpression)(query.query);
    if (query.query !== '') {
      combinedQuery = (0, _esQuery.toElasticsearchQuery)(ast, dataView);
    }
    const filterQuery = (0, _esQuery.buildQueryFromFilters)(filters, dataView);
    if (combinedQuery.bool === undefined) {
      combinedQuery.bool = {};
      // toElasticsearchQuery may add a single multi_match item to the
      // root of its returned query, rather than putting it inside
      // a bool.should
      // in this case, move it to a bool.should
      if (combinedQuery.multi_match !== undefined) {
        combinedQuery.bool.should = {
          multi_match: combinedQuery.multi_match
        };
        delete combinedQuery.multi_match;
      }
    }
    if (Array.isArray(combinedQuery.bool.filter) === false) {
      combinedQuery.bool.filter = combinedQuery.bool.filter === undefined ? [] : [combinedQuery.bool.filter];
    }
    if (Array.isArray(combinedQuery.bool.must_not) === false) {
      combinedQuery.bool.must_not = combinedQuery.bool.must_not === undefined ? [] : [combinedQuery.bool.must_not];
    }
    combinedQuery.bool.filter = [...combinedQuery.bool.filter, ...filterQuery.filter];
    combinedQuery.bool.must_not = [...combinedQuery.bool.must_not, ...filterQuery.must_not];
  } else {
    const esQueryConfigs = (0, _public.getEsQueryConfig)(kibanaConfig);
    combinedQuery = (0, _esQuery.buildEsQuery)(dataView, [query], filters, esQueryConfigs);
  }
  return {
    query,
    combinedQuery
  };
}

// Only model plot cardinality relevant
// format:[{id:"cardinality_model_plot_high",modelPlotCardinality:11405}, {id:"cardinality_partition_field",fieldName:"clientip"}]

function checkCardinalitySuccess(data) {
  const response = {
    success: true
  };
  // There were no fields to run cardinality on.
  if (Array.isArray(data) && data.length === 0) {
    return response;
  }
  for (let i = 0; i < data.length; i++) {
    if (data[i].id === 'success_cardinality') {
      break;
    }
    if (data[i].id === 'cardinality_model_plot_high') {
      response.success = false;
      response.highCardinality = data[i].modelPlotCardinality;
      break;
    }
  }
  return response;
}