"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ByFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _split_field_select = require("../split_field_select");
var _job_creator_context = require("../../../job_creator_context");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ByFieldSelector = ({
  detectorIndex
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const runtimeCategoryFields = (0, _react.useMemo)(() => (0, _fields_utils.filterCategoryFields)(jobCreator.runtimeFields), []);
  const allCategoryFields = (0, _react.useMemo)(() => [..._new_job_capabilities_service.newJobCapsService.categoryFields, ...runtimeCategoryFields].sort((a, b) => a.name.localeCompare(b.name)),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [byField, setByField] = (0, _react.useState)(jobCreator.getByField(detectorIndex));
  const categoryFields = useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated);
  (0, _react.useEffect)(() => {
    jobCreator.setByField(byField, detectorIndex);
    // add the by field to the influencers
    if (byField !== null && jobCreator.influencers.includes(byField.name) === false) {
      jobCreator.addInfluencer(byField.name);
    }
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [byField]);
  (0, _react.useEffect)(() => {
    const bf = jobCreator.getByField(detectorIndex);
    setByField(bf);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_split_field_select.SplitFieldSelect, {
    fields: categoryFields,
    changeHandler: setByField,
    selectedField: byField,
    isClearable: true,
    testSubject: "mlByFieldSelect",
    placeholder: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.populationField.placeholder', {
      defaultMessage: 'Split data'
    })
  });
};

// remove the population (over) field from the by field options
exports.ByFieldSelector = ByFieldSelector;
function useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated) {
  const [fields, setFields] = (0, _react.useState)(allCategoryFields);
  (0, _react.useEffect)(() => {
    const pf = jobCreator.populationField;
    if (pf !== null) {
      setFields(allCategoryFields.filter(({
        name
      }) => name !== pf.name));
    } else {
      setFields(allCategoryFields);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return fields;
}